vec4 color = texture2D(blurInputSampler, texcoord);

#ifdef BLUR_ENABLED
	float blurRadius = 1.0 - color.a;
	if (blurRadius > 0.0) {
		float invBlurRadius1 = 1.0 / blurRadius;
		blurRadius *= 256.0; //actual radius in pixels
		float invBlurRadius2 = 1.0 / blurRadius;

		vec4 average = vec4(color.rgb * color.rgb, 1.0);

		int stepCount = int(clamp(blurRadius, 1.0, float(BLUR_QUALITY)));
		float invStepCount = 1.0 / float(stepCount);
		float stepSize = blurRadius * pixelSizeY * invStepCount;
		float bottomBound = pixelSizeY * 0.5;
		float topBound = 1.0 - bottomBound;

		for (int currentStep = 1; currentStep <= stepCount; currentStep++) {
			float weight = fogify(currentStep * invStepCount, 0.35);
			float y;
			vec4 newColor;
			float newWeight;

			y = texcoord.y - float(currentStep) * stepSize;
			if (y >= bottomBound) {
				newColor = texture2D(blurInputSampler, vec2(texcoord.x, y));
				newWeight = weight * (1.0 - newColor.a) * invBlurRadius1;
				average += vec4(newColor.rgb * newColor.rgb * newWeight, newWeight);
			}

			y = texcoord.y + float(currentStep) * stepSize;
			if (y <= topBound) {
				newColor = texture2D(blurInputSampler, vec2(texcoord.x, y));
				newWeight = weight * (1.0 - newColor.a) * invBlurRadius1;
				average += vec4(newColor.rgb * newColor.rgb * newWeight, newWeight);
			}
		}
		color.rgb = sqrt(average.rgb / average.a);
	}
#endif