/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.mixin.gui;

import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_341;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_640;
import net.minecraft.class_7591;
import net.minecraft.class_7919;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccessor;
import obro1961.chatpatches.config.ChatSearchSetting;
import obro1961.chatpatches.gui.MenuButtonWidget;
import obro1961.chatpatches.gui.SearchButtonWidget;
import obro1961.chatpatches.util.ChatUtils;
import obro1961.chatpatches.util.RenderUtils;
import obro1961.chatpatches.util.SharedVariables;
import obro1961.chatpatches.util.StringTextUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_408.class})
public abstract class ChatScreenMixin
extends class_437 {
    @Unique
    private static final String SUGGESTION = class_2561.method_43471((String)"text.chatpatches.search.suggestion").getString();
    @Unique
    private static final class_2561 SEARCH_TOOLTIP = class_2561.method_43471((String)"text.chatpatches.search.desc");
    @Unique
    private static final class_2561 COPY_MENU_STRING = class_2561.method_43471((String)"text.chatpatches.copy.copyString");
    @Unique
    private static final class_2561 COPY_RAW_STRING = class_2561.method_43471((String)"text.chatpatches.copy.rawString");
    @Unique
    private static final class_2561 COPY_FORMATTED_STRING = class_2561.method_43471((String)"text.chatpatches.copy.formattedString");
    @Unique
    private static final class_2561 COPY_JSON_STRING = class_2561.method_43471((String)"text.chatpatches.copy.jsonString");
    @Unique
    private static final class_2561 COPY_MENU_TIMESTAMP = class_2561.method_43471((String)"text.chatpatches.copy.timestamp");
    @Unique
    private static final class_2561 COPY_TIMESTAMP_TEXT = class_2561.method_43471((String)"text.chatpatches.copy.timestampText");
    @Unique
    private static final class_2561 COPY_TIMESTAMP_HOVER_TEXT = class_2561.method_43471((String)"text.chatpatches.copy.timestampHoverText");
    @Unique
    private static final class_2561 COPY_UNIX = class_2561.method_43471((String)"text.chatpatches.copy.unix");
    @Unique
    private static final class_2561 COPY_MENU_LINKS = class_2561.method_43471((String)"text.chatpatches.copy.links");
    @Unique
    private static final Function<Integer, class_2561> COPY_LINK_N = n -> class_2561.method_43469((String)"text.chatpatches.copy.linkN", (Object[])new Object[]{n});
    @Unique
    private static final class_2561 COPY_MENU_SENDER = class_2561.method_43471((String)"text.chatpatches.copy.sender");
    @Unique
    private static final class_2561 COPY_NAME = class_2561.method_43471((String)"text.chatpatches.copy.name");
    @Unique
    private static final class_2561 COPY_UUID = class_2561.method_43471((String)"text.chatpatches.copy.uuid");
    @Unique
    private static final class_2561 COPY_MENU_REPLY = class_2561.method_43471((String)"text.chatpatches.copy.reply");
    @Unique
    private static final int SEARCH_X = 22;
    @Unique
    private static final int SEARCH_Y_OFFSET = -31;
    @Unique
    private static final int SEARCH_H = 12;
    @Unique
    private static final double SEARCH_W_MULT = 0.25;
    @Unique
    private static final int MENU_WIDTH = 146;
    @Unique
    private static final int MENU_HEIGHT = 76;
    @Unique
    private static final int MENU_X = 2;
    @Unique
    private static final int MENU_Y_OFFSET = -113;
    @Unique
    private static boolean showSearch = true;
    @Unique
    private static boolean showSettingsMenu = false;
    @Unique
    private static boolean showCopyMenu = false;
    @Unique
    private static class_303 selectedLine = RenderUtils.NIL_HUD_LINE;
    @Unique
    private static Map<class_2561, MenuButtonWidget> mainButtons = new LinkedHashMap<class_2561, MenuButtonWidget>();
    @Unique
    private static Map<class_2561, MenuButtonWidget> hoverButtons = new LinkedHashMap<class_2561, MenuButtonWidget>();
    @Unique
    private static List<class_303.class_7590> hoveredVisibles = new ArrayList<class_303.class_7590>();
    @Unique
    private static String searchDraft = "";
    @Unique
    private static String messageDraft = "";
    @Unique
    private class_342 searchField;
    @Unique
    private SearchButtonWidget searchButton;
    @Unique
    private String lastSearch;
    @Unique
    private PatternSyntaxException searchError;
    @Shadow
    protected class_342 field_2382;
    @Shadow
    private String field_18973;

    protected ChatScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void chatScreenInit(String originalChatText, CallbackInfo ci) {
        if (ChatPatches.config.messageDrafting && !messageDraft.isBlank()) {
            if (SharedVariables.FABRIC_LOADER.isModLoaded("smwyg") && originalChatText.matches("^\\[[\\w\\s]+]$")) {
                messageDraft = originalChatText;
            } else if (!originalChatText.equals("/")) {
                this.field_18973 = messageDraft;
            }
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    protected void initSearchStuff(CallbackInfo ci) {
        this.searchButton = new SearchButtonWidget(2, this.field_22790 - 35, me -> {
            showSearch = !showSearch;
        }, me -> {
            showSettingsMenu = !showSettingsMenu;
        });
        this.searchButton.method_47400(class_7919.method_47407((class_2561)SEARCH_TOOLTIP));
        this.searchField = new class_342(this.field_22787.field_1772, 22, this.field_22790 + -31, (int)((double)this.field_22789 * 0.25), 12, (class_2561)class_2561.method_43471((String)"chat.editBox"));
        this.searchField.method_1880(384);
        this.searchField.method_1858(false);
        this.searchField.method_1887(SUGGESTION);
        this.searchField.method_1863(this::onSearchFieldUpdate);
        if (ChatPatches.config.searchDrafting) {
            this.searchField.method_1852(searchDraft);
        }
        int yPos = this.field_22790 + -56 - 51;
        ChatSearchSetting.caseSensitive = new ChatSearchSetting("caseSensitive", true, yPos, 0);
        ChatSearchSetting.modifiers = new ChatSearchSetting("modifiers", false, yPos, 22);
        ChatSearchSetting.regex = new ChatSearchSetting("regex", false, yPos, 44);
        if (!ChatPatches.config.hideSearchButton) {
            this.method_25429((class_364)this.searchField);
            this.method_37063((class_364)this.searchButton);
        }
        if (!showCopyMenu) {
            hoverButtons.put(COPY_RAW_STRING, MenuButtonWidget.of(1, COPY_RAW_STRING, () -> selectedLine.comp_893().getString()));
            hoverButtons.put(COPY_FORMATTED_STRING, MenuButtonWidget.of(1, COPY_FORMATTED_STRING, () -> StringTextUtils.reorder(selectedLine.comp_893().method_30937(), true)));
            hoverButtons.put(COPY_JSON_STRING, MenuButtonWidget.of(1, COPY_JSON_STRING, () -> class_2561.class_2562.method_10867((class_2561)selectedLine.comp_893())));
            hoverButtons.put(COPY_LINK_N.apply(0), MenuButtonWidget.of(1, COPY_LINK_N.apply(0), () -> ""));
            hoverButtons.put(COPY_TIMESTAMP_TEXT, MenuButtonWidget.of(1, COPY_TIMESTAMP_TEXT, () -> ((class_2561)selectedLine.comp_893().method_10855().get(0)).getString()));
            hoverButtons.put(COPY_TIMESTAMP_HOVER_TEXT, MenuButtonWidget.of(1, COPY_TIMESTAMP_HOVER_TEXT, () -> {
                class_2568 hoverEvent = ((class_2561)selectedLine.comp_893().method_10855().get(0)).method_10866().method_10969();
                if (hoverEvent != null) {
                    return ((class_2561)hoverEvent.method_10891(class_2568.class_5247.field_24342)).getString();
                }
                return "";
            }));
            hoverButtons.put(COPY_NAME, MenuButtonWidget.of(1, COPY_NAME, () -> {
                class_2561 message = (class_2561)selectedLine.comp_893().method_10855().get(1);
                class_5250 text = message.method_10855().size() > 0 ? (class_2561)message.method_10855().get(0) : class_2561.method_43473();
                class_2568.class_5248 player = text.method_10866().method_10969() != null ? (class_2568.class_5248)text.method_10866().method_10969().method_10891(class_2568.class_5247.field_24344) : null;
                return player != null ? player.field_24353.getString() : text.getString();
            }));
            hoverButtons.put(COPY_UUID, MenuButtonWidget.of(1, COPY_UUID, () -> {
                class_2561 message = (class_2561)selectedLine.comp_893().method_10855().get(1);
                class_5250 text = message.method_10855().size() > 0 ? (class_2561)message.method_10855().get(0) : class_2561.method_43473();
                class_2568.class_5248 player = text.method_10866().method_10969() != null ? (class_2568.class_5248)text.method_10866().method_10969().method_10891(class_2568.class_5247.field_24344) : null;
                return player != null ? player.field_24352.toString() : text.getString();
            }));
            mainButtons.put(COPY_MENU_STRING, MenuButtonWidget.of(0, COPY_MENU_STRING, hoverButtons.get(COPY_RAW_STRING), hoverButtons.get(COPY_FORMATTED_STRING), hoverButtons.get(COPY_JSON_STRING)));
            mainButtons.put(COPY_MENU_LINKS, MenuButtonWidget.of(0, COPY_MENU_LINKS, hoverButtons.get(COPY_LINK_N.apply(0))));
            mainButtons.put(COPY_MENU_TIMESTAMP, MenuButtonWidget.of(0, COPY_MENU_TIMESTAMP, hoverButtons.get(COPY_TIMESTAMP_TEXT), hoverButtons.get(COPY_TIMESTAMP_HOVER_TEXT)));
            mainButtons.put(COPY_UNIX, MenuButtonWidget.of(0, COPY_UNIX, () -> {
                List siblings = selectedLine.comp_893().method_10855();
                String time = siblings.size() > 0 ? ((class_2561)siblings.get(0)).method_10866().method_10955() : null;
                return time != null && !time.isEmpty() ? time : "?";
            }));
            mainButtons.put(COPY_MENU_SENDER, MenuButtonWidget.of(0, COPY_MENU_SENDER, hoverButtons.get(COPY_NAME), hoverButtons.get(COPY_UUID)));
            mainButtons.put(COPY_MENU_REPLY, MenuButtonWidget.of(0, COPY_MENU_REPLY, () -> "").setOtherPressAction(menuButton -> this.field_2382.method_1852(StringTextUtils.fillVars(ChatPatches.config.copyReplyFormat, ChatScreenMixin.hoverButtons.get((Object)ChatScreenMixin.COPY_NAME).copySupplier.get()))));
            int mainWidth = mainButtons.values().stream().mapToInt(button -> button.width).max().getAsInt() - 2 * MenuButtonWidget.padding;
            int mW = mainWidth = Math.max(mainWidth, this.field_22787.field_1772.method_27525((class_5348)COPY_MENU_SENDER) + 40);
            mainButtons.values().forEach(menuButton -> menuButton.setWidth(mW));
            hoverButtons.values().forEach(menuButton -> {
                menuButton.xOffset = ChatScreenMixin.mainButtons.get((Object)ChatScreenMixin.COPY_MENU_STRING).width;
            });
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void renderSearchStuff(class_332 drawContext, int mX, int mY, float delta, CallbackInfo ci) {
        if (showSearch && !ChatPatches.config.hideSearchButton) {
            drawContext.method_25294(20, this.field_22790 + -31 - 2, (int)((double)this.field_22789 * 0.31), this.field_22790 + -31 + 12 - 2, this.field_22787.field_1690.method_19344(Integer.MIN_VALUE));
            this.searchField.method_25394(drawContext, mX, mY, delta);
            if (this.searchError != null) {
                int x = this.searchField.method_46426() + 8 + (int)((double)this.field_22789 * 0.25);
                drawContext.method_25303(this.field_22793, this.searchError.getMessage().split(System.lineSeparator())[0], x, this.searchField.method_46427(), 0xD00000);
            }
        }
        if (showSettingsMenu && !ChatPatches.config.hideSearchButton) {
            drawContext.method_25290(class_2960.method_43902((String)"chatpatches", (String)"textures/gui/search_settings_panel.png"), 2, this.field_22790 + -113, 0.0f, 0.0f, 146, 76, 146, 76);
            ChatSearchSetting.caseSensitive.button.method_25394(drawContext, mX, mY, delta);
            ChatSearchSetting.modifiers.button.method_25394(drawContext, mX, mY, delta);
            ChatSearchSetting.regex.button.method_25394(drawContext, mX, mY, delta);
        }
        if (showCopyMenu && !hoveredVisibles.isEmpty() && !this.isMouseOverSettingsMenu(mX, mY)) {
            class_338 chatHud = this.field_22787.field_1705.method_1743();
            ChatHudAccessor chat = ChatHudAccessor.from(chatHud);
            List<class_303.class_7590> visibles = chat.chatPatches$getVisibleMessages();
            int hoveredParts = hoveredVisibles.size();
            double s = chatHud.method_1814();
            int lH = chat.chatPatches$getLineHeight();
            int sW = class_3532.method_15384((double)((double)chatHud.method_1811() / s));
            int sH = class_3532.method_15357((double)((double)(this.field_22787.method_22683().method_4502() - 40) / s));
            int shift = class_3532.method_15357((double)((double)ChatPatches.config.shiftChat / s));
            int i = visibles.indexOf(hoveredVisibles.get(hoveredParts - 1)) - chat.chatPatches$getScrolledLines();
            int hoveredY = sH - i * lH - shift;
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_22905((float)s, (float)s, 1.0f);
            int borderW = sW + 8;
            int scissorY1 = class_3532.method_15357((double)((double)(sH - chatHud.method_1813() * lH - shift - 1) * s));
            int scissorY2 = class_3532.method_15357((double)((double)(sH - shift + 1) * s));
            int selectionY1 = hoveredY - lH * hoveredParts;
            int selectionH = lH * hoveredParts + 1;
            drawContext.method_44379(0, scissorY1, borderW, scissorY2);
            drawContext.method_49601(0, selectionY1, borderW, selectionH, ChatPatches.config.copyColor + -16777216);
            drawContext.method_44380();
            drawContext.method_51448().method_22909();
            mainButtons.values().forEach(menuButton -> menuButton.render(drawContext, mX, mY, delta));
            hoverButtons.values().forEach(menuButton -> {
                if (menuButton.is(COPY_LINK_N.apply(0))) {
                    ChatScreenMixin.mainButtons.get((Object)ChatScreenMixin.COPY_MENU_LINKS).children.forEach(linkButton -> linkButton.render(drawContext, mX, mY, delta));
                } else {
                    menuButton.render(drawContext, mX, mY, delta);
                }
            });
        }
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawHoverEvent(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Style;II)V")})
    public boolean renderTooltipSmartly(class_332 drawContext, class_327 textRenderer, class_2583 style, int mX, int mY) {
        return !this.isMouseOverSettingsMenu(mX, mY) && !this.isMouseOverCopyMenu(mX, mY);
    }

    @Inject(method={"resize"}, at={@At(value="TAIL")})
    public void updateSearchOnResize(class_310 client, int width, int height, CallbackInfo ci) {
        String text = this.searchField.method_1882();
        this.searchField.method_1852(text);
        this.onSearchFieldUpdate(text);
        if (showCopyMenu) {
            this.loadCopyMenu(MenuButtonWidget.anchor.x, MenuButtonWidget.anchor.y);
        }
        if (!text.isEmpty()) {
            this.searchField.method_1887(null);
        }
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;tick()V")})
    public void tickSearchField(class_342 chatField, Operation<Void> tick) {
        if (ChatSearchSetting.updateSearchColor) {
            this.onSearchFieldUpdate(this.searchField.method_1882());
        }
        if (this.searchField.method_25370() && !ChatPatches.config.hideSearchButton) {
            this.searchField.method_1865();
        } else {
            tick.call(new Object[]{chatField});
        }
    }

    @Inject(method={"removed"}, at={@At(value="TAIL")})
    public void onScreenClose(CallbackInfo ci) {
        if (ChatPatches.config.messageDrafting) {
            messageDraft = this.field_2382.method_1882();
        }
        if (ChatPatches.config.searchDrafting) {
            searchDraft = this.searchField.method_1882();
        } else if (!this.searchField.method_1882().isEmpty()) {
            this.field_22787.field_1705.method_1743().method_1817();
        }
        this.resetCopyMenu();
    }

    @WrapOperation(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;setScreen(Lnet/minecraft/client/gui/screen/Screen;)V", ordinal=0)})
    public void allowClosingSettings(class_310 client, class_437 nullScreen, Operation<Void> setScreen) {
        if (showSettingsMenu) {
            showSettingsMenu = false;
        } else {
            setScreen.call(new Object[]{client, null});
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;setScreen(Lnet/minecraft/client/gui/screen/Screen;)V", ordinal=1, shift=At.Shift.AFTER)})
    private void onMessageSentEmptyDraft(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        messageDraft = "";
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;mouseClicked(DDI)Z")})
    private boolean disableChatFieldFocus(class_342 chatField, double mX, double mY, int button, Operation<Boolean> mouseClicked) {
        if (!ChatPatches.config.hideSearchButton) {
            return false;
        }
        return (Boolean)mouseClicked.call(new Object[]{chatField, mX, mY, button});
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/ChatHud;mouseClicked(DD)Z")})
    private boolean fixMenuClickthroughClick(class_338 chatHud, double mX, double mY, Operation<Boolean> mouseClicked) {
        if (this.isMouseOverSettingsMenu(mX, mY) || this.isMouseOverCopyMenu(mX, mY)) {
            return false;
        }
        return (Boolean)mouseClicked.call(new Object[]{chatHud, mX, mY});
    }

    @WrapOperation(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ChatScreen;getTextStyleAt(DD)Lnet/minecraft/text/Style;")})
    private class_2583 fixMenuClickthroughStyle(class_408 screen, double mX, double mY, Operation<class_2583> getTextStyleAt) {
        if (this.isMouseOverSettingsMenu(mX, mY) || this.isMouseOverCopyMenu(mX, mY)) {
            return null;
        }
        return (class_2583)getTextStyleAt.call(new Object[]{screen, mX, mY});
    }

    @Inject(method={"mouseClicked"}, at={@At(value="TAIL")}, cancellable=true)
    public void afterClickBtn(double mX, double mY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (this.searchField.method_25402(mX, mY, button)) {
            cir.setReturnValue((Object)true);
        }
        if (showSettingsMenu) {
            if (ChatSearchSetting.caseSensitive.button.method_25402(mX, mY, button)) {
                cir.setReturnValue((Object)true);
            }
            if (ChatSearchSetting.modifiers.button.method_25402(mX, mY, button)) {
                cir.setReturnValue((Object)true);
            }
            if (ChatSearchSetting.regex.button.method_25402(mX, mY, button)) {
                cir.setReturnValue((Object)true);
            }
        } else if (button == 1) {
            RenderUtils.MousePos before = MenuButtonWidget.anchor;
            MenuButtonWidget.anchor = RenderUtils.MousePos.of((int)mX, (int)mY);
            if (this.loadCopyMenu(mX, mY)) {
                showCopyMenu = true;
                cir.setReturnValue((Object)true);
            } else {
                MenuButtonWidget.anchor = before;
                showCopyMenu = false;
                cir.setReturnValue((Object)false);
            }
        } else if (button == 0 && showCopyMenu) {
            if (mainButtons.values().stream().anyMatch(menuButton -> menuButton.mouseClicked(mX, mY, button))) {
                cir.setReturnValue((Object)true);
            }
            if (hoverButtons.values().stream().anyMatch(hoverButton -> hoverButton.mouseClicked(mX, mY, button))) {
                cir.setReturnValue((Object)true);
            } else if (ChatScreenMixin.mainButtons.get((Object)ChatScreenMixin.COPY_MENU_LINKS).children.stream().anyMatch(linkButton -> linkButton.mouseClicked(mX, mY, button))) {
                cir.setReturnValue((Object)true);
            }
            showCopyMenu = false;
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    public void method_16014(double mX, double mY) {
        if (showCopyMenu) {
            mainButtons.values().forEach(menuButton -> menuButton.mouseMoved(mX, mY));
        }
    }

    @Unique
    private boolean isMouseOverSettingsMenu(double mX, double mY) {
        return showSettingsMenu && mX >= 2.0 && mX <= 148.0 && mY >= (double)(this.field_22790 + -113) && mY <= (double)(this.field_22790 + -113 + 76);
    }

    @Unique
    private boolean isMouseOverCopyMenu(double mX, double mY) {
        return showCopyMenu && Stream.concat(mainButtons.values().stream(), hoverButtons.values().stream()).anyMatch(menuButton -> menuButton.isMouseOver(mX, mY));
    }

    @Unique
    @NotNull
    private List<class_303.class_7590> getFullMessageAt(double mX, double mY) {
        int end_index;
        int start_index;
        if (mX < 0.0 || mY < 0.0) {
            return new ArrayList<class_303.class_7590>(0);
        }
        ChatHudAccessor chatHud = ChatHudAccessor.from(this.field_22787);
        List<class_303.class_7590> visibles = chatHud.chatPatches$getVisibleMessages();
        int hoveredIndex = chatHud.chatPatches$getMessageLineIndex(chatHud.chatPatches$toChatLineX(mX), chatHud.chatPatches$toChatLineY(mY + (double)ChatPatches.config.shiftChat));
        if (hoveredIndex == -1) {
            return new ArrayList<class_303.class_7590>(0);
        }
        if (visibles.get(hoveredIndex).comp_898()) {
            for (start_index = hoveredIndex + 1; start_index < visibles.size() && !visibles.get(start_index).comp_898(); ++start_index) {
            }
            --start_index;
            end_index = hoveredIndex;
        } else {
            for (start_index = hoveredIndex; start_index < visibles.size() && !visibles.get(start_index).comp_898(); ++start_index) {
            }
            for (end_index = --start_index; end_index >= 0 && !visibles.get(end_index).comp_898(); --end_index) {
            }
        }
        ArrayList<class_303.class_7590> messageParts = new ArrayList<class_303.class_7590>(start_index - end_index);
        for (int i = start_index; i >= end_index; --i) {
            messageParts.add(visibles.get(i));
        }
        return messageParts;
    }

    @Unique
    private boolean loadCopyMenu(double mX, double mY) {
        class_2583 style;
        if (mX < 0.0 || mY < 0.0) {
            return false;
        }
        this.resetCopyMenu();
        hoveredVisibles = this.getFullMessageAt(mX, mY);
        if (hoveredVisibles.isEmpty()) {
            return false;
        }
        class_338 chatHud = this.field_22787.field_1705.method_1743();
        ChatHudAccessor chat = ChatHudAccessor.from(chatHud);
        String hoveredMessageFirst = StringTextUtils.reorder(hoveredVisibles.get(0).comp_896(), false);
        selectedLine = chat.chatPatches$getMessages().stream().filter(msg -> class_124.method_539((String)msg.comp_893().getString()).startsWith(hoveredMessageFirst)).findFirst().orElse(RenderUtils.NIL_HUD_LINE);
        if (selectedLine.equals((Object)RenderUtils.NIL_HUD_LINE)) {
            return false;
        }
        ChatScreenMixin.mainButtons.get((Object)ChatScreenMixin.COPY_MENU_STRING).button.field_22764 = true;
        List<String> links = StringTextUtils.getLinks(selectedLine.comp_893().getString());
        if (!links.isEmpty()) {
            for (String link : links) {
                MenuButtonWidget linkButton = MenuButtonWidget.of(1, COPY_LINK_N.apply(links.indexOf(link) + 1), () -> link);
                linkButton.xOffset = ChatScreenMixin.mainButtons.get((Object)ChatScreenMixin.COPY_MENU_LINKS).width;
                linkButton.button.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)("\u00a79" + link))));
                ChatScreenMixin.mainButtons.get((Object)ChatScreenMixin.COPY_MENU_LINKS).children.add(linkButton);
            }
            mainButtons.get(COPY_MENU_LINKS).readyToRender(true);
        }
        if (!((class_2561)selectedLine.comp_893().method_10855().get(0)).getString().isBlank()) {
            mainButtons.get(COPY_MENU_TIMESTAMP).readyToRender(true);
        }
        mainButtons.get(COPY_UNIX).readyToRender(true);
        class_5250 originalMessage = selectedLine.comp_893().method_10855().size() > 1 ? (class_2561)selectedLine.comp_893().method_10855().get(1) : class_2561.method_43473();
        class_2583 class_25832 = style = originalMessage.method_10855().size() > 0 ? ((class_2561)originalMessage.method_10855().get(0)).method_10866() : class_2583.field_24360;
        if (!style.equals((Object)class_2583.field_24360) && style.method_10969() != null && style.method_10969().method_10892() == class_2568.class_5247.field_24344) {
            class_640 player = this.field_22787.method_1562().method_2871(UUID.fromString(ChatScreenMixin.hoverButtons.get((Object)ChatScreenMixin.COPY_UUID).copySupplier.get()));
            class_2960 skinTexture = player == null ? this.field_22787.method_1582().method_44705(ChatUtils.NIL_MSG_DATA.sender()) : (player.method_2967() ? player.method_2968() : this.field_22787.method_1582().method_44705(player.method_2966() != null ? player.method_2966() : ChatUtils.NIL_MSG_DATA.sender()));
            mainButtons.get(COPY_MENU_SENDER).setTexture(skinTexture).readyToRender(true);
            mainButtons.get(COPY_MENU_REPLY).setTexture(skinTexture).readyToRender(true);
        }
        mainButtons.values().forEach(menuButton -> {
            if (menuButton.is(COPY_MENU_LINKS)) {
                int i = 0;
                while (i < menuButton.children.size()) {
                    menuButton.children.get(i).alignTo((MenuButtonWidget)menuButton).offsetY(++i);
                }
            } else {
                for (MenuButtonWidget child : menuButton.children) {
                    child.alignTo((MenuButtonWidget)menuButton).offsetY(menuButton.children.indexOf(child) + 1).updateTooltip();
                }
            }
        });
        long mainHeight = mainButtons.values().stream().filter(menuButton -> menuButton.button.field_22764).count();
        long hoverHeight = hoverButtons.values().stream().filter(menuButton -> menuButton.button.field_22764).count();
        int copyMenuHeight = (int)Math.max(mainHeight, hoverHeight) * MenuButtonWidget.height;
        if (copyMenuHeight + MenuButtonWidget.anchor.y > this.field_22787.method_22683().method_4502()) {
            MenuButtonWidget.anchor.y -= copyMenuHeight - (this.field_22787.method_22683().method_4502() - MenuButtonWidget.anchor.y) + 2;
        }
        showCopyMenu = true;
        return true;
    }

    @Unique
    private void resetCopyMenu() {
        showCopyMenu = false;
        selectedLine = RenderUtils.NIL_HUD_LINE;
        hoveredVisibles.clear();
        MenuButtonWidget.mainOffsets = 0;
        MenuButtonWidget.hoverOffsets = 0;
        mainButtons.values().forEach(MenuButtonWidget::cancelRender);
        hoverButtons.values().forEach(menuButton -> {
            if (menuButton.is(COPY_LINK_N.apply(0))) {
                ChatScreenMixin.mainButtons.get((Object)ChatScreenMixin.COPY_MENU_LINKS).children.clear();
            } else {
                menuButton.cancelRender();
            }
        });
    }

    @Unique
    private void onSearchFieldUpdate(String text) {
        if (text.equals(this.lastSearch != null ? this.lastSearch : "") && !ChatSearchSetting.updateSearchColor) {
            return;
        }
        if (!text.isEmpty()) {
            this.searchField.method_1887(null);
            if (ChatSearchSetting.regex.on) {
                try {
                    Pattern.compile(text);
                    this.searchError = null;
                }
                catch (PatternSyntaxException e) {
                    this.searchError = e;
                    this.searchField.method_1868(0xFF5555);
                    this.field_22787.field_1705.method_1743().method_1817();
                }
            }
            List<class_303.class_7590> searchResults = this.filterMessages(this.searchError != null ? null : text);
            if (this.searchError == null && searchResults.isEmpty()) {
                this.searchField.method_1868(0xFFFF55);
                this.field_22787.field_1705.method_1743().method_1817();
            } else if (!searchResults.isEmpty()) {
                this.searchField.method_1868(0x55FF55);
                ChatHudAccessor chatHud = ChatHudAccessor.from(this.field_22787);
                chatHud.chatPatches$getVisibleMessages().clear();
                chatHud.chatPatches$getVisibleMessages().addAll(searchResults);
            }
        } else {
            this.field_22787.field_1705.method_1743().method_1817();
            this.searchError = null;
            this.searchField.method_1868(0xE0E0E0);
            this.searchField.method_1887(SUGGESTION);
        }
        this.lastSearch = text;
        ChatSearchSetting.updateSearchColor = false;
    }

    @Unique
    private List<class_303.class_7590> filterMessages(String target) {
        ChatHudAccessor chatHud = ChatHudAccessor.from(this.field_22787);
        if (target == null) {
            return this.createVisibles(chatHud.chatPatches$getMessages());
        }
        ArrayList msgs = Lists.newArrayList(chatHud.chatPatches$getMessages());
        msgs.removeIf(hudLn -> {
            String content = StringTextUtils.reorder(hudLn.comp_893().method_30937(), ChatSearchSetting.modifiers.on);
            return !(!ChatSearchSetting.regex.on ? (!ChatSearchSetting.caseSensitive.on ? StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)target) : content.contains(target)) : content.matches((ChatSearchSetting.caseSensitive.on ? "(?i)" : "") + target));
        });
        return this.createVisibles(msgs);
    }

    @Unique
    private List<class_303.class_7590> createVisibles(List<class_303> messages) {
        ArrayList generated = Lists.newArrayListWithExpectedSize((int)messages.size());
        class_338 chatHud = this.field_22787.field_1705.method_1743();
        messages.forEach(hudLn -> {
            class_7591 ind = hudLn.comp_894();
            int width = (int)((double)chatHud.method_1811() / chatHud.method_1814()) - (ind != null && ind.comp_900() != null ? ind.comp_900().field_39766 + 6 : 0);
            List list = class_341.method_1850((class_5348)hudLn.comp_893(), (int)width, (class_327)this.field_22787.field_1772);
            for (int i = list.size() - 1; i >= 0; --i) {
                generated.add(new class_303.class_7590(hudLn.comp_892(), (class_5481)list.get(i), ind, i == list.size() - 1));
            }
        });
        return generated;
    }
}

