/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.mixin.gui;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7469;
import net.minecraft.class_7591;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.accessor.ChatHudAccessor;
import obro1961.chatpatches.chatlog.ChatLog;
import obro1961.chatpatches.config.Config;
import obro1961.chatpatches.util.ChatUtils;
import obro1961.chatpatches.util.Flags;
import obro1961.chatpatches.util.SharedVariables;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_338.class}, priority=500)
public abstract class ChatHudMixin
implements ChatHudAccessor {
    @Shadow
    @Final
    private class_310 field_2062;
    @Shadow
    @Final
    private List<class_303> field_2061;
    @Shadow
    @Final
    private List<class_303.class_7590> field_2064;
    @Shadow
    @Final
    private List<?> field_40392;
    @Shadow
    private int field_2066;

    @Shadow
    public abstract double method_1814();

    @Shadow
    public abstract int method_1813();

    @Shadow
    protected abstract double method_44722(double var1);

    @Shadow
    protected abstract double method_44724(double var1);

    @Shadow
    protected abstract int method_44752();

    @Shadow
    protected abstract int method_44725(double var1, double var3);

    @Shadow
    protected abstract void method_1815(class_2561 var1, @Nullable class_7469 var2, int var3, @Nullable class_7591 var4, boolean var5);

    @Override
    public List<class_303> chatPatches$getMessages() {
        return this.field_2061;
    }

    @Override
    public List<class_303.class_7590> chatPatches$getVisibleMessages() {
        return this.field_2064;
    }

    @Override
    public int chatPatches$getScrolledLines() {
        return this.field_2066;
    }

    @Override
    public int chatPatches$getMessageLineIndex(double x, double y) {
        return this.method_44725(x, y);
    }

    @Override
    public double chatPatches$toChatLineX(double x) {
        return this.method_44722(x);
    }

    @Override
    public double chatPatches$toChatLineY(double y) {
        return this.method_44724(y);
    }

    @Override
    public int chatPatches$getLineHeight() {
        return this.method_44752();
    }

    @Inject(method={"clear"}, at={@At(value="HEAD")}, cancellable=true)
    private void clear(boolean clearHistory, CallbackInfo ci) {
        if (!ChatPatches.config.vanillaClearing) {
            if (!clearHistory) {
                this.field_2062.method_44714().method_44945();
                this.field_40392.clear();
                this.field_2061.clear();
                this.field_2064.clear();
                ChatLog.clearMessages();
                ChatLog.clearHistory();
            }
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;ILnet/minecraft/client/gui/hud/MessageIndicator;Z)V"}, at={@At(value="CONSTANT", args={"intValue=100"})})
    private int moreMessages(int hundred) {
        return ChatPatches.config.chatMaxMessages;
    }

    @ModifyReturnValue(method={"getWidth()I"}, at={@At(value="RETURN")})
    private int moreWidth(int defaultWidth) {
        return ChatPatches.config.chatWidth > 0 ? ChatPatches.config.chatWidth : defaultWidth;
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE", ordinal=0), index=31)
    private int moveChatText(int x) {
        return x - class_3532.method_15357((double)((double)ChatPatches.config.shiftChat / this.method_1814()));
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE", ordinal=0), index=27)
    private int moveScrollBar(int af) {
        return af + class_3532.method_15357((double)((double)ChatPatches.config.shiftChat / this.method_1814()));
    }

    @ModifyVariable(method={"getIndicatorAt", "getTextStyleAt"}, argsOnly=true, at=@At(value="HEAD"), ordinal=1)
    private double moveINDHoverText(double e) {
        return e + (double)ChatPatches.config.shiftChat * this.method_1814();
    }

    @ModifyVariable(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;ILnet/minecraft/client/gui/hud/MessageIndicator;Z)V"}, at=@At(value="HEAD"), argsOnly=true)
    private class_2561 modifyMessage(class_2561 message, class_2561 m, class_7469 sig, int ticks, class_7591 indicator, boolean refreshing) {
        if (refreshing || Flags.LOADING_CHATLOG.isRaised() || Flags.ADDING_CONDENSED_MESSAGE.isRaised()) {
            return message;
        }
        class_2583 style = message.method_10866();
        boolean lastEmpty = SharedVariables.lastMsg.equals(ChatUtils.NIL_MSG_DATA);
        boolean boundary = Flags.BOUNDARY_LINE.isRaised() && ChatPatches.config.boundary && !ChatPatches.config.vanillaClearing;
        Date now = lastEmpty ? new Date() : Date.from(SharedVariables.lastMsg.timestamp());
        String nowTime = String.valueOf(now.getTime());
        class_5250 modified = class_2561.method_43473().method_10862(style).method_10852((class_2561)(ChatPatches.config.time && !boundary ? ChatPatches.config.makeTimestamp(now).method_10862(ChatPatches.config.makeHoverStyle(now).method_10975(nowTime)) : class_2561.method_43473().method_10862(class_2583.field_24360.method_10975(nowTime)))).method_10852((class_2561)(!lastEmpty && !boundary && Config.getOption("chatNameFormat").changed() && SharedVariables.lastMsg.vanilla() ? class_2561.method_43473().method_10862(style).method_10852((class_2561)ChatPatches.config.formatPlayername(SharedVariables.lastMsg.sender())).method_10852((class_2561)class_156.method_656(() -> {
            class_7417 patt0$temp = message.method_10851();
            if (patt0$temp instanceof class_2588) {
                class_2588 ttc = (class_2588)patt0$temp;
                class_5250 text = class_2561.method_43473().method_10862(style);
                List<class_2561> messages = Arrays.stream(ttc.method_11023()).map(arg -> (class_2561)arg).toList();
                for (int i = 1; i < messages.size(); ++i) {
                    text.method_10852(messages.get(i));
                }
                return text;
            }
            class_7417 patt1$temp = message.method_10851();
            if (patt1$temp instanceof class_2585) {
                class_2585 ltc = (class_2585)patt1$temp;
                String[] splitMessage = ltc.comp_737().split(">");
                if (splitMessage.length > 1) {
                    return class_2561.method_43470((String)splitMessage[1].replaceAll("^\\s+", "")).method_10862(style);
                }
                return message.method_27662().method_10862(style);
            }
            return message.method_27662().method_10862(style);
        })).method_10852((class_2561)class_156.method_656(() -> {
            class_2561 rightTri;
            String rightTriStr;
            String restOfStr;
            class_2585 ltc;
            class_5250 msg = class_2561.method_43473().method_10862(style);
            List siblings = message.method_10855();
            int i = -1;
            class_7417 patt0$temp = message.method_10851();
            if (patt0$temp instanceof class_2585 && !(ltc = (class_2585)patt0$temp).comp_737().contains(">")) {
                i = siblings.stream().filter(sib -> sib.getString().contains(">")).mapToInt(siblings::indexOf).findFirst().orElse(i);
            }
            if (i > -1 && !(restOfStr = (rightTriStr = (rightTri = (class_2561)siblings.get(i)).getString()).substring(rightTriStr.indexOf(">") + 1).replaceAll("^\\s+", "")).isEmpty()) {
                siblings.set(i, class_2561.method_43470((String)restOfStr).method_10862(rightTri.method_10866()));
                --i;
            }
            for (int j = i + 1; j < siblings.size(); ++j) {
                msg.method_10852((class_2561)siblings.get(j));
            }
            return msg;
        })) : message));
        ChatLog.addMessage((class_2561)modified);
        return modified;
    }

    @Inject(method={"addToMessageHistory"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    private void addHistory(String message, CallbackInfo ci) {
        if (!Flags.LOADING_CHATLOG.isRaised()) {
            ChatLog.addHistory(message);
        }
    }

    @Inject(method={"logChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void dontLogRestoredMessages(class_2561 message, @Nullable class_7591 indicator, CallbackInfo ci) {
        if (Flags.LOADING_CHATLOG.isRaised() && indicator != null) {
            ci.cancel();
        }
    }

    @Inject(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;ILnet/minecraft/client/gui/hud/MessageIndicator;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void addCounter(class_2561 incoming, class_7469 msd, int ticks, class_7591 mi, boolean refreshing, CallbackInfo ci) {
        try {
            if (ChatPatches.config.counter && !refreshing && !this.field_2061.isEmpty() && !Flags.ADDING_CONDENSED_MESSAGE.isRaised()) {
                class_2561 condensedLastMessage = ChatUtils.getCondensedMessage(incoming, 0);
                if (ChatPatches.config.counterCompact && condensedLastMessage.equals((Object)incoming)) {
                    int attemptDistance = class_3532.method_15340((int)(ChatPatches.config.counterCompactDistance == -1 ? this.field_2061.size() : (ChatPatches.config.counterCompactDistance == 0 ? this.method_1813() : ChatPatches.config.counterCompactDistance)), (int)0, (int)this.field_2061.size());
                    this.field_2061.subList(1, attemptDistance).stream().filter(hudLine -> ((class_2561)hudLine.comp_893().method_10855().get(1)).getString().equalsIgnoreCase(((class_2561)incoming.method_10855().get(1)).getString())).findFirst().ifPresent(hudLine -> ChatUtils.getCondensedMessage(incoming, this.field_2061.indexOf(hudLine)));
                }
                if (!condensedLastMessage.equals((Object)incoming) || ChatPatches.config.counterCompact && condensedLastMessage.equals((Object)incoming)) {
                    Flags.ADDING_CONDENSED_MESSAGE.raise();
                    this.method_1815(condensedLastMessage, msd, ticks, mi, false);
                    Flags.ADDING_CONDENSED_MESSAGE.lower();
                    ci.cancel();
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            ChatPatches.LOGGER.error("[ChatHudMixin.addCounter] Couldn't add duplicate counter because message '{}' ({} parts) was not constructed properly.", (Object)incoming.getString(), (Object)incoming.method_10855().size());
            ChatPatches.LOGGER.error("[ChatHudMixin.addCounter] This could have also been caused by an issue with the new CompactChat dupe-condensing method.");
            ChatPatches.LOGGER.error("[ChatHudMixin.addCounter] Either way, this was caused by a bug or mod incompatibility. Please report this on GitHub or on the Discord!", (Throwable)e);
        }
        catch (Exception e) {
            ChatPatches.LOGGER.error("[ChatHudMixin.addCounter] /!\\ Couldn't add duplicate counter because of an unexpected error. Please report this on GitHub or on the Discord! /!\\", (Throwable)e);
        }
    }
}

