/*
 * Decompiled with CFR 0.152.
 */
package obro1961.chatpatches.config;

import com.google.common.collect.Lists;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import obro1961.chatpatches.ChatPatches;
import obro1961.chatpatches.config.Config;
import obro1961.chatpatches.util.Flags;
import obro1961.chatpatches.util.SharedVariables;

public class YACLConfig
extends Config {
    @Override
    public class_437 getConfigScreen(class_437 parent) {
        ArrayList timeOpts = Lists.newArrayList();
        ArrayList hoverOpts = Lists.newArrayList();
        ArrayList counterOpts = Lists.newArrayList();
        ArrayList compactChatOpts = Lists.newArrayList();
        ArrayList boundaryOpts = Lists.newArrayList();
        ArrayList chatHudOpts = Lists.newArrayList();
        ArrayList chatScreenOpts = Lists.newArrayList();
        ArrayList copyMenuOpts = Lists.newArrayList();
        Config.getOptions().forEach(opt -> {
            OptionFlag[] optionFlagArray;
            String key = opt.key;
            String cat = key.split("[A-Z]")[0];
            if (key.contains("counterCompact")) {
                cat = "compact";
            } else if (!class_1074.method_4663((String)("text.chatpatches.category." + cat))) {
                cat = "screen";
            }
            if (key.contains("Color")) {
                opt = new Config.ConfigOption<Color>(new Color((Integer)opt.get()), new Color((Integer)opt.def), key){

                    @Override
                    public Color get() {
                        return new Color((Integer)Config.getOption(this.key).get());
                    }

                    @Override
                    public void set(Object value) {
                        super.set(((Color)value).getRGB() - -16777216);
                    }
                };
            }
            Option.Builder builder = Option.createBuilder().name((class_2561)class_2561.method_43471((String)("text.chatpatches." + key))).description(YACLConfig.desc(opt)).controller(me -> YACLConfig.getController(me, key)).binding(YACLConfig.getBinding(opt));
            if (key.matches(".*[Cc]hat.*")) {
                OptionFlag[] optionFlagArray2 = new OptionFlag[1];
                optionFlagArray = optionFlagArray2;
                optionFlagArray2[0] = client -> client.field_1705.method_1743().method_1817();
            } else {
                optionFlagArray = new OptionFlag[]{};
            }
            Option yaclOpt = builder.flag(optionFlagArray).build();
            switch (cat) {
                case "time": {
                    timeOpts.add(yaclOpt);
                    break;
                }
                case "hover": {
                    hoverOpts.add(yaclOpt);
                    break;
                }
                case "counter": {
                    counterOpts.add(yaclOpt);
                    break;
                }
                case "compact": {
                    compactChatOpts.add(yaclOpt);
                    break;
                }
                case "boundary": {
                    boundaryOpts.add(yaclOpt);
                    break;
                }
                case "chat": {
                    chatHudOpts.add(yaclOpt);
                    break;
                }
                case "screen": {
                    chatScreenOpts.add(yaclOpt);
                    break;
                }
                case "copy": {
                    copyMenuOpts.add(yaclOpt);
                }
            }
        });
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"text.chatpatches.title")).category(YACLConfig.category("time", timeOpts, new OptionGroup[0])).category(YACLConfig.category("hover", hoverOpts, new OptionGroup[0])).category(YACLConfig.category("counter", counterOpts, YACLConfig.group("counter.compact", compactChatOpts, class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://modrinth.com/mod/compact-chat"))))).category(YACLConfig.category("boundary", boundaryOpts, new OptionGroup[0])).category(YACLConfig.category("chat", List.of(), YACLConfig.group("chat.hud", chatHudOpts, null), YACLConfig.group("chat.screen", chatScreenOpts, null))).category(YACLConfig.category("copy", copyMenuOpts, new OptionGroup[0])).category(YACLConfig.category("help", List.of(YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.dateFormat"), "https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html"), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.formatCodes"), "https://minecraft.gamepedia.com/Formatting_codes"), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.faq"), "https://github.com/mrbuilder1961/ChatPatches#faq"), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.regex"), "https://docs.oracle.com/javase/7/docs/api/java/util/regex/Pattern.html"), YACLConfig.label(class_2561.method_43471((String)"text.chatpatches.help.regexTester"), "https://regex101.com/")), new OptionGroup[0])).save(() -> {
            YACLConfig.write();
            ChatPatches.LOGGER.info("[YACLConfig.save] Updated the config file at '{}'!", (Object)CONFIG_PATH);
        });
        if (SharedVariables.FABRIC_LOADER.isDevelopmentEnvironment()) {
            builder.category(YACLConfig.category("debug", List.of(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Edit Bit Flags (%d^10, %s^2)".formatted(Flags.flags, Integer.toBinaryString(Flags.flags)))).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)15)).step((Number)1)).binding((Object)Flags.flags, () -> Flags.flags, inc -> {
                Flags.flags = inc;
            }).build(), ButtonOption.createBuilder().name((class_2561)class_2561.method_43470((String)"Print GitHub Option table")).action((yaclScreen, buttonOption) -> {
                StringBuilder str = new StringBuilder();
                Config.getOptions().forEach(opt -> str.append("\n| %s | %s | %s | `text.chatpatches.%s` |".formatted(class_1074.method_4662((String)("text.chatpatches." + opt.key), (Object[])new Object[0]), opt.getType().equals(Integer.class) && opt.key.contains("Color") ? "`0x%06x`".formatted(opt.def) : (opt.getType().equals(String.class) ? "`\"" + String.valueOf(opt.def) + "\"`" : "`" + String.valueOf(opt.def) + "`"), class_1074.method_4662((String)("text.chatpatches.desc." + opt.key), (Object[])new Object[0]), opt.key)));
                ChatPatches.LOGGER.warn("[YACLConfig.printGithubTables]" + String.valueOf(str));
            }).build()), new OptionGroup[0]));
        }
        return builder.build().generateScreen(parent);
    }

    private static <T> ControllerBuilder<T> getController(Option<T> opt, String key) {
        if (key.matches("^.*(?:Str|Date|Format)$")) {
            return StringControllerBuilder.create(opt);
        }
        if (key.contains("Color")) {
            return ColorControllerBuilder.create(opt);
        }
        if (Config.getOption(key).get() instanceof Integer) {
            return ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create(opt).range((Number)YACLConfig.getMinOrMax(key, true), (Number)YACLConfig.getMinOrMax(key, false))).step((Number)YACLConfig.getInterval(key));
        }
        return BooleanControllerBuilder.create(opt).coloured(true);
    }

    private static <T> Binding<T> getBinding(Config.ConfigOption<?> option) {
        Config.ConfigOption<?> o = option;
        if (o.key.contains("Date")) {
            return Binding.generic(o.def, o::get, inc -> {
                try {
                    new SimpleDateFormat(inc.toString());
                    o.set(inc);
                }
                catch (IllegalArgumentException e) {
                    ChatPatches.LOGGER.error("[YACLConfig.getBinding] Invalid date format '{}' provided for '{}'", inc, (Object)o.key);
                }
            });
        }
        if (o.key.contains("Format")) {
            return Binding.generic(o.def, o::get, inc -> o.set(inc, inc.toString().contains("$")));
        }
        return Binding.generic(o.def, o::get, o::set);
    }

    private static int getMinOrMax(String key, boolean min) {
        if (min) {
            return switch (key) {
                case "counterCompactDistance" -> -1;
                default -> 0;
            };
        }
        return switch (key) {
            case "counterCompactDistance" -> 1024;
            case "chatWidth" -> 630;
            case "chatMaxMessages" -> Short.MAX_VALUE;
            case "shiftChat" -> 100;
            default -> 100;
        };
    }

    private static int getInterval(String key) {
        return switch (key) {
            case "chatMaxMessages" -> 16;
            default -> 1;
        };
    }

    private static ConfigCategory category(String key, List<Option<?>> options, OptionGroup ... groups) {
        ConfigCategory.Builder builder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)("text.chatpatches.category." + key)));
        if (class_1074.method_4663((String)("text.chatpatches.category.desc." + key))) {
            builder.tooltip(new class_2561[]{class_2561.method_43471((String)("text.chatpatches.category.desc." + key))});
        }
        if (groups.length > 0) {
            builder.groups(List.of(groups));
        }
        if (!options.isEmpty()) {
            builder.options(options);
        }
        return builder.build();
    }

    private static OptionGroup group(String key, List<Option<?>> options, class_2583 descriptionStyle) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)("text.chatpatches.category." + key))).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)("text.chatpatches.category.desc." + key)).method_27696(descriptionStyle != null ? descriptionStyle : class_2583.field_24360)})).options(options).build();
    }

    private static OptionDescription desc(Config.ConfigOption<?> opt) {
        OptionDescription.Builder builder = OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)("text.chatpatches.desc." + opt.key))});
        String ext = "webp";
        String image = "textures/preview/" + opt.key.replaceAll("([A-Z])", "_$1").toLowerCase() + "." + ext;
        class_2960 id = class_2960.method_43902((String)"chatpatches", (String)image);
        try {
            if (class_310.method_1551().method_1478().method_14486(id).isPresent()) {
                builder.webpImage(id);
            } else {
                ChatPatches.LOGGER.debug("[YACLConfig.desc] No .{} image found for '{}'", (Object)ext, (Object)opt.key.replaceAll("([A-Z])", "_$1").toLowerCase());
            }
        }
        catch (Throwable e) {
            ChatPatches.LOGGER.error("[YACLConfig.desc] An error occurred while trying to use '{}:{}' :", new Object[]{"chatpatches", image, e});
        }
        return builder.build();
    }

    private static Option<class_2561> label(class_5250 labelText, String urlTooltip) {
        return LabelOption.create((class_2561)labelText.method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, urlTooltip))));
    }
}

