/*
 * Decompiled with CFR 0.152.
 */
package com.nebspacefarer.stendhal.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import net.fabricmc.loader.api.FabricLoader;

public class StendhalConfig {
    String configPath = FabricLoader.getInstance().getConfigDir() + "/stendhal/stendhal.properties";
    File fileConfig = new File(this.configPath);
    private static final StendhalConfig instance = new StendhalConfig();

    public static StendhalConfig getInstance() {
        return instance;
    }

    public void createConfigFile() {
        if (!this.fileConfig.exists()) {
            try {
                if (new File(FabricLoader.getInstance().getConfigDir() + "/stendhal").mkdirs()) {
                    System.out.println("[Stendhal] Config folder created.");
                }
                if (this.fileConfig.createNewFile()) {
                    System.out.println("[Stendhal] Config file created.");
                    FileWriter fileWriter = new FileWriter(this.configPath);
                    fileWriter.write("### Stendhal Configuration File ###\n\n# Toggle on or off the chat unicode buttons\nchatutils.symbols.toggle=true\n\n# Choose the position of the chat unicode buttons\nchatutils.symbols.position=right\n\n# Give the amount of unicode buttons to display. 0 = all (might not show properly on your screen)\nchatutils.symbols.amount=20\n\n");
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getValue(String key) {
        try {
            Scanner scanner = new Scanner(this.fileConfig);
            while (scanner.hasNextLine()) {
                String configLine = scanner.nextLine();
                if (!configLine.split("=", 2)[0].equals(key)) continue;
                scanner.close();
                return configLine.split("=", 2)[1];
            }
            scanner.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setValue(String key, String value) {
        try {
            Scanner scanner = new Scanner(this.fileConfig);
            ArrayList<String> configLines = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                Object configLine = scanner.nextLine();
                if (((String)configLine).split("=", 2)[0].equals(key)) {
                    configLine = ((String)configLine).split("=", 2)[0] + "=" + value;
                }
                configLines.add((String)configLine);
            }
            scanner.close();
            FileWriter fileWriter = new FileWriter(this.fileConfig);
            fileWriter.write(String.join((CharSequence)"\n", configLines));
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

