/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.mixin;

import com.mojang.blaze3d.audio.OggAudioStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import team.creative.ambientsounds.sound.OggAudioStreamExtended;

@Mixin(value={OggAudioStream.class})
public abstract class OggAudioStreamMixin
implements OggAudioStreamExtended {
    private static final Random RANDOM = new Random();
    @Shadow
    private long f_83746_;
    @Shadow
    @Final
    private AudioFormat f_83747_;
    @Shadow
    @Final
    private InputStream f_83748_;
    @Shadow
    private ByteBuffer f_83749_;

    @Override
    public void setPositionRandomly(long length) throws IOException {
        if (length == 0L) {
            return;
        }
        int skipped = RANDOM.nextInt((int)(length - length / 4L));
        this.f_83748_.skipNBytes(skipped);
        STBVorbis.stb_vorbis_flush_pushdata((long)this.f_83746_);
        this.f_83749_.limit(0);
        this.m_83765_();
        if (!this.seekTillPage()) {
            throw new IOException("No page found till end of file.");
        }
    }

    private boolean seekTillPage() throws IOException {
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer data = memorystack.mallocPointer(1);
            IntBuffer channels = memorystack.mallocInt(1);
            IntBuffer samples = memorystack.mallocInt(1);
            while (true) {
                int used = STBVorbis.stb_vorbis_decode_frame_pushdata((long)this.f_83746_, (ByteBuffer)this.f_83749_, (IntBuffer)channels, (PointerBuffer)data, (IntBuffer)samples);
                this.f_83749_.position(this.f_83749_.position() + used);
                int error = STBVorbis.stb_vorbis_get_error((long)this.f_83746_);
                if (error == 1) {
                    this.m_83767_();
                    if (this.m_83765_()) continue;
                    boolean bl = false;
                    return bl;
                }
                if (error != 0) {
                    throw new IOException("Failed to read Ogg file " + error);
                }
                if (used == 0) {
                    this.f_83749_.limit(0);
                    this.m_83765_();
                    continue;
                }
                int k = samples.get(0);
                if (k == 0) continue;
                int l = channels.get(0);
                if (l != 2 && l != 1) {
                    throw new IllegalStateException("Invalid number of channels: " + l);
                }
                boolean bl = true;
                return bl;
            }
        }
    }

    @Shadow
    private void m_83767_() {
        throw new UnsupportedOperationException();
    }

    @Shadow
    private boolean m_83765_() throws IOException {
        throw new UnsupportedOperationException();
    }
}

