/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.level.entity.forge;

import dev.architectury.platform.forge.EventBuses;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;

public class SpawnPlacementsRegistryImpl {
    private static List<Entry<?>> entries = new ArrayList();

    public static <T extends Mob> void register(Supplier<? extends EntityType<T>> type, SpawnPlacements.Type spawnPlacement, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        if (entries == null) {
            throw new IllegalStateException("SpawnPlacementsRegistry.register must not be called after the registry has been collected!");
        }
        entries.add(new Entry<T>(type, spawnPlacement, heightmapType, spawnPredicate));
    }

    static {
        EventBuses.onRegistered("architectury", bus -> bus.addListener(event -> {
            Iterator<Entry<?>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                Entry<?> entry;
                Entry<?> casted = entry = iterator.next();
                event.register(casted.type().get(), casted.spawnPlacement(), casted.heightmapType(), casted.spawnPredicate(), SpawnPlacementRegisterEvent.Operation.OR);
            }
            entries = null;
        }));
    }

    private record Entry<T extends Mob>(Supplier<? extends EntityType<T>> type, SpawnPlacements.Type spawnPlacement, Heightmap.Types heightmapType, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
    }
}

