/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.forge;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.architectury.registry.CreativeTabOutput;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.CreativeModeTabRegistry;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="architectury", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CreativeTabRegistryImpl {
    private static final Logger LOGGER = LogManager.getLogger(CreativeTabRegistryImpl.class);
    private static final List<Consumer<BuildCreativeModeTabContentsEvent>> BUILD_CONTENTS_LISTENERS = new ArrayList<Consumer<BuildCreativeModeTabContentsEvent>>();
    private static final Multimap<TabKey, java.util.function.Supplier<ItemStack>> APPENDS = MultimapBuilder.hashKeys().arrayListValues().build();

    @SubscribeEvent
    public static void event(BuildCreativeModeTabContentsEvent event) {
        for (Consumer<BuildCreativeModeTabContentsEvent> listener : BUILD_CONTENTS_LISTENERS) {
            listener.accept(event);
        }
    }

    @ApiStatus.Experimental
    public static CreativeModeTab create(Consumer<CreativeModeTab.Builder> callback) {
        CreativeModeTab.Builder builder = CreativeModeTab.builder();
        callback.accept(builder);
        return builder.m_257652_();
    }

    @ApiStatus.Experimental
    public static DeferredSupplier<CreativeModeTab> ofBuiltin(final CreativeModeTab tab) {
        ResourceLocation key = BuiltInRegistries.f_279662_.m_7981_((Object)tab);
        if (key == null) {
            throw new IllegalArgumentException("Builtin tab %s is not registered!".formatted(tab));
        }
        return new DeferredSupplier<CreativeModeTab>(){

            @Override
            public ResourceLocation getRegistryId() {
                return Registries.f_279569_.m_135782_();
            }

            @Override
            public ResourceLocation getId() {
                return BuiltInRegistries.f_279662_.m_7981_((Object)tab);
            }

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public CreativeModeTab get() {
                return tab;
            }
        };
    }

    @ApiStatus.Experimental
    public static DeferredSupplier<CreativeModeTab> defer(final ResourceLocation name) {
        return new DeferredSupplier<CreativeModeTab>(){
            @Nullable
            private CreativeModeTab tab;

            @Override
            public ResourceLocation getRegistryId() {
                return Registries.f_279569_.m_135782_();
            }

            @Override
            public ResourceLocation getId() {
                return name;
            }

            @Override
            public CreativeModeTab get() {
                this.resolve();
                if (this.tab == null) {
                    throw new IllegalStateException("Creative tab %s was not registered yet!".formatted(name));
                }
                return this.tab;
            }

            @Override
            public boolean isPresent() {
                this.resolve();
                return this.tab != null;
            }

            private void resolve() {
                if (this.tab == null) {
                    this.tab = (CreativeModeTab)BuiltInRegistries.f_279662_.m_7745_(name);
                }
            }
        };
    }

    public static void modify(DeferredSupplier<CreativeModeTab> tab, CreativeTabRegistry.ModifyTabCallback filler) {
        BUILD_CONTENTS_LISTENERS.add(event -> {
            if (tab.isPresent()) {
                if (event.getTab().equals(tab.get())) {
                    filler.accept(event.getFlags(), CreativeTabRegistryImpl.wrapTabOutput((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries()), event.hasPermissions());
                }
            } else if (Objects.equals(CreativeModeTabRegistry.getName((CreativeModeTab)event.getTab()), tab.getId())) {
                filler.accept(event.getFlags(), CreativeTabRegistryImpl.wrapTabOutput((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)event.getEntries()), event.hasPermissions());
            }
        });
    }

    private static CreativeTabOutput wrapTabOutput(final MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries) {
        return new CreativeTabOutput(){

            @Override
            public void acceptAfter(ItemStack after, ItemStack stack, CreativeModeTab.TabVisibility visibility) {
                if (after.m_41619_()) {
                    entries.put((Object)stack, (Object)visibility);
                } else {
                    entries.putAfter((Object)after, (Object)stack, (Object)visibility);
                }
            }

            @Override
            public void acceptBefore(ItemStack before, ItemStack stack, CreativeModeTab.TabVisibility visibility) {
                if (before.m_41619_()) {
                    entries.put((Object)stack, (Object)visibility);
                } else {
                    entries.putBefore((Object)before, (Object)stack, (Object)visibility);
                }
            }
        };
    }

    @ApiStatus.Experimental
    public static void appendStack(DeferredSupplier<CreativeModeTab> tab, java.util.function.Supplier<ItemStack> item) {
        APPENDS.put((Object)new TabKey.SupplierTabKey(tab), item);
    }

    static {
        BUILD_CONTENTS_LISTENERS.add(event -> {
            for (Map.Entry keyEntry : APPENDS.asMap().entrySet()) {
                Supplier stacks = Suppliers.memoize(() -> ((Collection)keyEntry.getValue()).stream().map(java.util.function.Supplier::get).toList());
                Object patt2971$temp = keyEntry.getKey();
                if (patt2971$temp instanceof TabKey.SupplierTabKey) {
                    TabKey.SupplierTabKey supplierTabKey = (TabKey.SupplierTabKey)patt2971$temp;
                    if (!Objects.equals(CreativeModeTabRegistry.getName((CreativeModeTab)event.getTab()), supplierTabKey.supplier().getId())) continue;
                    for (ItemStack stack : (List)stacks.get()) {
                        event.getEntries().put((Object)stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                    }
                    continue;
                }
                Object patt3417$temp = keyEntry.getKey();
                if (!(patt3417$temp instanceof TabKey.DirectTabKey)) continue;
                TabKey.DirectTabKey directTabKey = (TabKey.DirectTabKey)patt3417$temp;
                if (!event.getTab().equals(directTabKey.tab())) continue;
                for (ItemStack stack : (List)stacks.get()) {
                    event.getEntries().put((Object)stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                }
            }
        });
    }

    private static interface TabKey {

        public record DirectTabKey(CreativeModeTab tab) implements TabKey
        {
            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DirectTabKey)) {
                    return false;
                }
                DirectTabKey that = (DirectTabKey)o;
                return this.tab == that.tab;
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this.tab);
            }
        }

        public record SupplierTabKey(DeferredSupplier<CreativeModeTab> supplier) implements TabKey
        {
            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SupplierTabKey)) {
                    return false;
                }
                SupplierTabKey that = (SupplierTabKey)o;
                return Objects.equals(this.supplier.getId(), that.supplier.getId());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.supplier.getId());
            }
        }
    }
}

