/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.compat.ContraptionCollidable;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.Emitter;
import eu.ha3.presencefootsteps.world.Solver;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PFSolver
implements Solver {
    private static final Logger logger = LogManager.getLogger((String)"PFSolver");
    private static final double TRAP_DOOR_OFFSET = 0.1;
    private final Isolator isolator;

    public PFSolver(Isolator isolator) {
        this.isolator = isolator;
    }

    @Override
    public boolean playAssociation(LivingEntity ply, Association assos, State eventType) {
        if (!assos.isResult()) {
            return false;
        }
        if (!assos.isNotEmitter()) {
            if ((assos = assos.at(ply)).hasAssociation()) {
                this.isolator.getAcoustics().playAcoustic(assos, eventType, Options.EMPTY);
            } else {
                this.isolator.getStepPlayer().playStep(assos);
            }
        }
        return true;
    }

    @Override
    public Association findAssociation(LivingEntity ply, double verticalOffsetAsMinus, boolean isRightFoot) {
        double rot = Math.toRadians(Mth.m_14177_((float)ply.m_146908_()));
        Vec3 pos = ply.m_20182_();
        float feetDistanceToCenter = 0.2f * (float)(isRightFoot ? -1 : 1) * PlayerUtil.getScale(ply);
        BlockPos footPos = BlockPos.m_274561_((double)(pos.f_82479_ + Math.cos(rot) * (double)feetDistanceToCenter), (double)(ply.m_20191_().m_82340_(Direction.Axis.Y) - 0.1 - verticalOffsetAsMinus), (double)(pos.f_82481_ + Math.sin(rot) * (double)feetDistanceToCenter));
        if (feetDistanceToCenter > 1.0f) {
            for (BlockPos underfootPos : BlockPos.m_121925_((BlockPos)footPos, (int)((int)feetDistanceToCenter), (int)2, (int)((int)feetDistanceToCenter))) {
                Association assos = this.findAssociation((Entity)ply, underfootPos);
                if (!assos.hasAssociation()) continue;
                return assos;
            }
        }
        return this.findAssociation((Entity)ply, footPos);
    }

    private Association findAssociation(Entity player, BlockPos pos) {
        boolean isXdangMax;
        Association worked;
        Vec3 vel;
        if (!(player instanceof RemotePlayer) && (vel = player.m_20184_()).m_82556_() != 0.0 && Math.abs(vel.f_82480_) < 0.004) {
            return Association.NOT_EMITTER;
        }
        AABB collider = player.m_20191_();
        collider = collider.m_82386_(0.0, -(collider.f_82289_ - Math.floor(collider.f_82289_)), 0.0);
        double expansionRatio = 0.1;
        collider = collider.m_82400_(expansionRatio);
        if (player.m_20142_()) {
            collider = collider.m_82377_(0.3, 0.5, 0.3);
        }
        if (!(worked = this.findAssociation(player, pos, collider)).isNull()) {
            return worked;
        }
        double xdang = (player.m_20185_() - (double)pos.m_123341_()) * 2.0 - 1.0;
        double zdang = (player.m_20189_() - (double)pos.m_123343_()) * 2.0 - 1.0;
        if (Math.max(Math.abs(xdang), Math.abs(zdang)) <= (double)0.2f) {
            return worked;
        }
        boolean bl = isXdangMax = Math.abs(xdang) > Math.abs(zdang);
        worked = isXdangMax ? this.findAssociation(player, pos.m_122030_(xdang > 0.0 ? 1 : -1), collider) : this.findAssociation(player, pos.m_122020_(zdang > 0.0 ? 1 : -1), collider);
        if (!worked.isNull()) {
            return worked;
        }
        if (isXdangMax) {
            return this.findAssociation(player, pos.m_122020_(zdang > 0.0 ? 1 : -1), collider);
        }
        return this.findAssociation(player, pos.m_122030_(xdang > 0.0 ? 1 : -1), collider);
    }

    private String findForGolem(Level world, BlockPos pos, String substrate) {
        String golem;
        List golems = world.m_6443_(Entity.class, new AABB(pos).m_82377_(0.5, 0.0, 0.5), e -> !(e instanceof Player));
        if (!golems.isEmpty() && Emitter.isEmitter(golem = this.isolator.getGolemMap().getAssociation(((Entity)golems.get(0)).m_6095_(), substrate))) {
            logger.debug("Golem detected: " + golem);
            return golem;
        }
        return "UNASSIGNED";
    }

    private BlockState getBlockStateAt(Entity entity, BlockPos pos) {
        Level world = entity.m_9236_();
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() && entity instanceof ContraptionCollidable) {
            ContraptionCollidable collidable = (ContraptionCollidable)entity;
            state = collidable.getCollidedStateAt(pos);
        }
        return state;
    }

    private Association findAssociation(Entity entity, BlockPos pos, AABB collider) {
        String wet;
        BlockState in = this.getBlockStateAt(entity, pos);
        BlockPos up = pos.m_7494_();
        BlockState above = this.getBlockStateAt(entity, up);
        Object association = this.findForGolem(entity.m_9236_(), up, "carpet");
        boolean wasGolem = false;
        String wetAssociation = "NOT_EMITTER";
        if (!Emitter.isEmitter((String)association)) {
            association = this.isolator.getBlockMap().getAssociation(above, "carpet");
        } else {
            wasGolem = true;
        }
        if (Emitter.isEmitter((String)association)) {
            logger.debug("Carpet detected: " + (String)association);
            pos = up;
            in = above;
        } else {
            String foliage;
            VoxelShape shape;
            if (in.m_60795_() || in.m_60812_((BlockGetter)entity.m_9236_(), pos).m_83297_(Direction.Axis.Y) < (double)0.3f) {
                BlockPos down = pos.m_7495_();
                BlockState below = this.getBlockStateAt(entity, down);
                association = this.isolator.getBlockMap().getAssociation(below, "bigger");
                if (Emitter.isResult((String)association)) {
                    logger.debug("Fence detected: " + (String)association);
                    pos = down;
                    in = below;
                }
            }
            if ((shape = in.m_60812_((BlockGetter)entity.m_9236_(), pos)).m_83281_()) {
                shape = in.m_60808_((BlockGetter)entity.m_9236_(), pos);
            }
            if (!shape.m_83281_() && !shape.m_83215_().m_82338_(pos).m_82381_(collider)) {
                logger.debug("Skipping due to hitbox miss");
                return Association.NOT_EMITTER;
            }
            if (!Emitter.isResult((String)association)) {
                association = this.findForGolem(entity.m_9236_(), pos, "");
                if (!Emitter.isEmitter((String)association)) {
                    association = this.isolator.getBlockMap().getAssociation(in, "");
                } else {
                    wasGolem = true;
                }
            }
            if (Emitter.isEmitter((String)association) && Emitter.isEmitter(foliage = this.isolator.getBlockMap().getAssociation(above, "foliage"))) {
                logger.debug("Foliage detected: " + foliage);
                association = (String)association + "," + foliage;
            }
        }
        if (Emitter.isEmitter((String)association) && (entity.m_9236_().m_46758_(up) || !wasGolem && (in.m_60819_().m_205070_(FluidTags.f_13131_) || above.m_60819_().m_205070_(FluidTags.f_13131_))) && Emitter.isEmitter(wet = this.isolator.getBlockMap().getAssociation(in, "wet"))) {
            logger.debug("Wet block detected: " + wet);
            wetAssociation = wet;
        }
        if (Emitter.isNonEmitter((String)association) && Emitter.isNonEmitter(wetAssociation)) {
            return Association.NOT_EMITTER;
        }
        if (Emitter.isResult((String)association)) {
            return new Association(in, pos).withDry((String)association).withWet(wetAssociation);
        }
        if (in.m_60795_()) {
            return Association.NOT_EMITTER;
        }
        SoundType sounds = in.m_60827_();
        String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(sounds.f_56731_), Float.valueOf(sounds.f_56732_));
        String primitive = this.isolator.getPrimitiveMap().getAssociation(sounds, substrate);
        if (Emitter.isResult(primitive)) {
            return new Association(in, pos).withDry(primitive).withWet(wetAssociation);
        }
        return Association.NOT_EMITTER;
    }

    @Override
    public Association findAssociation(LivingEntity ply, BlockPos pos, String strategy) {
        if (!"find_messy_foliage".equals(strategy)) {
            return Association.NOT_EMITTER;
        }
        BlockState above = this.getBlockStateAt((Entity)ply, pos.m_7494_());
        String foliage = this.isolator.getBlockMap().getAssociation(above, "foliage");
        if (!Emitter.isEmitter(foliage)) {
            return Association.NOT_EMITTER;
        }
        if ("MESSY_GROUND".equals(this.isolator.getBlockMap().getAssociation(above, "messy"))) {
            return new Association(above, pos.m_7494_()).withDry(foliage);
        }
        return Association.NOT_EMITTER;
    }
}

