/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.world.Emitter;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class Association {
    public static final Association NOT_EMITTER = new Association();
    private final BlockState blockState;
    private final BlockPos pos;
    private String data = "NOT_EMITTER";
    private String wetData = "NOT_EMITTER";
    private LivingEntity source;

    public Association() {
        this(Blocks.f_50016_.m_49966_(), BlockPos.f_121853_);
    }

    public Association(BlockState state, BlockPos pos) {
        this.blockState = state;
        this.pos = pos;
    }

    public Association at(LivingEntity source) {
        if (!this.isNull()) {
            this.source = source;
        }
        return this;
    }

    public Association withDry(@Nullable String data) {
        if (!this.isNull() && data != null) {
            this.data = data;
        }
        return this;
    }

    public Association withWet(@Nullable String data) {
        if (!this.isNull() && data != null) {
            this.wetData = data;
        }
        return this;
    }

    public boolean isNull() {
        return this == NOT_EMITTER;
    }

    public boolean isNotEmitter() {
        return this.isNull() || Emitter.isNonEmitter(this.data) && Emitter.isNonEmitter(this.wetData);
    }

    public boolean hasAssociation() {
        return !this.isNotEmitter() && this.isResult();
    }

    public boolean isResult() {
        return Emitter.isResult(this.data) || Emitter.isResult(this.wetData);
    }

    public String getAcousticName() {
        return this.data;
    }

    public String getWetAcousticName() {
        return this.wetData;
    }

    public LivingEntity getSource() {
        return this.source;
    }

    public BlockState getState() {
        return this.blockState;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public SoundType getSoundGroup() {
        return this.blockState.m_60827_();
    }

    public boolean dataEquals(Association other) {
        return this.hasAssociation() && Objects.equals(this.data, other.data);
    }
}

