/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.stream.JsonWriter;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public class BlockReport {
    private final Path loc;

    public BlockReport(String baseName) {
        this.loc = BlockReport.getUniqueFileName(FMLPaths.GAMEDIR.get().resolve("presencefootsteps"), baseName, ".json");
    }

    public CompletableFuture<?> execute(@Nullable Predicate<BlockState> filter) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.writeReport(filter);
                this.printResults();
            }
            catch (Exception e) {
                BlockReport.addMessage((Component)Component.m_237110_((String)"pf.report.error", (Object[])new Object[]{e.getMessage()}).m_130938_(s -> s.m_131140_(ChatFormatting.RED)));
            }
        });
    }

    private void writeReport(@Nullable Predicate<BlockState> filter) throws IOException {
        Files.createDirectories(this.loc.getParent(), new FileAttribute[0]);
        try (JsonObjectWriter writer = JsonObjectWriter.of(new JsonWriter((Writer)Files.newBufferedWriter(this.loc, new OpenOption[0])));){
            writer.object(() -> {
                Object2ObjectOpenHashMap groups = new Object2ObjectOpenHashMap();
                writer.object("blocks", () -> this.lambda$writeReport$4(writer, (Map)groups, filter));
                writer.array("unmapped_entities", () -> writer.each(BuiltInRegistries.f_256780_, type -> {
                    ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_(type);
                    if (!PresenceFootsteps.getInstance().engine.getIsolator().getLocomotionMap().contains(id) && type.m_20615_((Level)Minecraft.m_91087_().f_91073_) instanceof LivingEntity) {
                        writer.writer().value(id.toString());
                    }
                }));
                writer.object("primitives", () -> BlockReport.lambda$writeReport$8(writer, (Map)groups));
            });
        }
    }

    private String getSoundData(@Nullable SoundType group) {
        if (group == null) {
            return "NULL";
        }
        if (group.m_56776_() == null) {
            return "NO_SOUND";
        }
        return group.m_56776_().m_11660_().m_135815_();
    }

    private String getClassData(BlockState state) {
        @Nullable String canonicalName = state.m_60734_().getClass().getCanonicalName();
        if (canonicalName == null) {
            return "<anonymous>";
        }
        return canonicalName;
    }

    private String getTagData(BlockState state) {
        return BuiltInRegistries.f_256975_.m_203613_().filter(arg_0 -> ((BlockState)state).m_204336_(arg_0)).map(TagKey::f_203868_).map(ResourceLocation::toString).collect(Collectors.joining(","));
    }

    private void printResults() {
        BlockReport.addMessage((Component)Component.m_237110_((String)"pf.report.save", (Object[])new Object[]{Component.m_237113_((String)this.loc.getFileName().toString()).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.loc.toString())).m_131157_(ChatFormatting.UNDERLINE))}).m_130938_(s -> s.m_131140_(ChatFormatting.GREEN)));
    }

    public static void addMessage(Component text) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(text);
    }

    static Path getUniqueFileName(Path directory, String baseName, String ext) {
        Path loc = null;
        int counter = 0;
        while (loc == null || Files.exists(loc, new LinkOption[0])) {
            loc = directory.resolve(baseName + (String)(counter == 0 ? "" : "_" + counter) + ext);
            ++counter;
        }
        return loc;
    }

    private static /* synthetic */ void lambda$writeReport$8(JsonObjectWriter writer, Map groups) throws IOException {
        writer.each(groups.values(), group -> {
            String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(group.f_56731_), Float.valueOf(group.f_56732_));
            writer.field(group.m_56776_().m_11660_().toString() + "@" + substrate, PresenceFootsteps.getInstance().engine.getIsolator().getPrimitiveMap().getAssociation((SoundType)group, substrate));
        });
    }

    private /* synthetic */ void lambda$writeReport$4(JsonObjectWriter writer, Map groups, Predicate filter) throws IOException {
        writer.each(BuiltInRegistries.f_256975_, block -> {
            BlockState state = block.m_49966_();
            SoundType group = block.m_49966_().m_60827_();
            if (group != null && group.m_56776_() != null) {
                String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(group.f_56731_), Float.valueOf(group.f_56732_));
                groups.put(group.m_56776_().m_11660_().toString() + "@" + substrate, group);
            }
            if (filter == null || filter.test(state)) {
                writer.object(BuiltInRegistries.f_256975_.m_7981_(block).toString(), () -> {
                    writer.field("class", this.getClassData(state));
                    writer.field("tags", this.getTagData(state));
                    writer.field("sound", this.getSoundData(group));
                    writer.field("association", PresenceFootsteps.getInstance().engine.getIsolator().getBlockMap().getAssociation(state, ""));
                });
            }
        });
    }
}

