/*
 * Decompiled with CFR 0.152.
 */
package reloc.net.fabricmc.accesswidener;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import reloc.net.fabricmc.accesswidener.AccessWidenerReader;
import reloc.net.fabricmc.accesswidener.AccessWidenerVisitor;
import reloc.net.fabricmc.accesswidener.EntryTriple;

public final class AccessWidener
implements AccessWidenerVisitor {
    String namespace;
    final Map<String, Access> classAccess = new HashMap<String, Access>();
    final Map<EntryTriple, Access> methodAccess = new HashMap<EntryTriple, Access>();
    final Map<EntryTriple, Access> fieldAccess = new HashMap<EntryTriple, Access>();
    final Set<String> classes = new LinkedHashSet<String>();

    @Override
    public void visitHeader(String namespace) {
        if (this.namespace != null && !this.namespace.equals(namespace)) {
            throw new RuntimeException(String.format("Namespace mismatch, expected %s got %s", this.namespace, namespace));
        }
        this.namespace = namespace;
    }

    @Override
    public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
        this.classAccess.put(name, this.applyAccess(access, this.classAccess.getOrDefault(name, ClassAccess.DEFAULT), null));
        this.addTargets(name);
    }

    @Override
    public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
        this.addOrMerge(this.methodAccess, new EntryTriple(owner, name, descriptor), access, MethodAccess.DEFAULT);
        this.addTargets(owner);
    }

    @Override
    public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
        this.addOrMerge(this.fieldAccess, new EntryTriple(owner, name, descriptor), access, FieldAccess.DEFAULT);
        this.addTargets(owner);
    }

    private void addTargets(String clazz) {
        clazz = clazz.replace('/', '.');
        this.classes.add(clazz);
        while (clazz.contains("$")) {
            clazz = clazz.substring(0, clazz.lastIndexOf("$"));
            this.classes.add(clazz);
        }
    }

    void addOrMerge(Map<EntryTriple, Access> map, EntryTriple entry, AccessWidenerReader.AccessType access, Access defaultAccess) {
        if (entry == null || access == null) {
            throw new RuntimeException("Input entry or access is null");
        }
        map.put(entry, this.applyAccess(access, map.getOrDefault(entry, defaultAccess), entry));
    }

    Access applyAccess(AccessWidenerReader.AccessType input, Access access, EntryTriple entryTriple) {
        switch (input) {
            case ACCESSIBLE: {
                this.makeClassAccessible(entryTriple);
                return access.makeAccessible();
            }
            case EXTENDABLE: {
                this.makeClassExtendable(entryTriple);
                return access.makeExtendable();
            }
            case MUTABLE: {
                return access.makeMutable();
            }
        }
        throw new UnsupportedOperationException("Unknown access type:" + (Object)((Object)input));
    }

    private void makeClassAccessible(EntryTriple entryTriple) {
        if (entryTriple == null) {
            return;
        }
        this.classAccess.put(entryTriple.getOwner(), this.applyAccess(AccessWidenerReader.AccessType.ACCESSIBLE, this.classAccess.getOrDefault(entryTriple.getOwner(), ClassAccess.DEFAULT), null));
    }

    private void makeClassExtendable(EntryTriple entryTriple) {
        if (entryTriple == null) {
            return;
        }
        this.classAccess.put(entryTriple.getOwner(), this.applyAccess(AccessWidenerReader.AccessType.EXTENDABLE, this.classAccess.getOrDefault(entryTriple.getOwner(), ClassAccess.DEFAULT), null));
    }

    Access getClassAccess(String className) {
        return this.classAccess.getOrDefault(className, ClassAccess.DEFAULT);
    }

    Access getFieldAccess(EntryTriple entryTriple) {
        return this.fieldAccess.getOrDefault(entryTriple, FieldAccess.DEFAULT);
    }

    Access getMethodAccess(EntryTriple entryTriple) {
        return this.methodAccess.getOrDefault(entryTriple, MethodAccess.DEFAULT);
    }

    public Set<String> getTargets() {
        return this.classes;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private static int makePublic(int i) {
        return i & 0xFFFFFFF9 | 1;
    }

    private static int makeProtected(int i) {
        if ((i & 1) != 0) {
            return i;
        }
        return i & 0xFFFFFFFD | 4;
    }

    private static int makeFinalIfPrivate(int access, String name, int ownerAccess) {
        if (name.equals("<init>")) {
            return access;
        }
        if ((ownerAccess & 0x200) != 0 || (access & 8) != 0) {
            return access;
        }
        if ((access & 2) != 0) {
            return access | 0x10;
        }
        return access;
    }

    private static int removeFinal(int i) {
        return i & 0xFFFFFFEF;
    }

    static enum ClassAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(access)),
        EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.removeFinal(access))),
        ACCESSIBLE_EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.removeFinal(access)));

        private final AccessOperator operator;

        private ClassAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == EXTENDABLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return EXTENDABLE;
        }

        @Override
        public Access makeMutable() {
            throw new UnsupportedOperationException("Classes cannot be made mutable");
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    static interface Access
    extends AccessOperator {
        public Access makeAccessible();

        public Access makeExtendable();

        public Access makeMutable();
    }

    static enum MethodAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(AccessWidener.makeFinalIfPrivate(access, name, ownerAccess))),
        EXTENDABLE((access, name, ownerAccess) -> AccessWidener.access$200(AccessWidener.removeFinal(access))),
        ACCESSIBLE_EXTENDABLE((access, name, owner) -> AccessWidener.access$100(AccessWidener.removeFinal(access)));

        private final AccessOperator operator;

        private MethodAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == EXTENDABLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_EXTENDABLE) {
                return ACCESSIBLE_EXTENDABLE;
            }
            return EXTENDABLE;
        }

        @Override
        public Access makeMutable() {
            throw new UnsupportedOperationException("Methods cannot be made mutable");
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    static enum FieldAccess implements Access
    {
        DEFAULT((access, name, ownerAccess) -> access),
        ACCESSIBLE((access, name, ownerAccess) -> AccessWidener.access$100(access)),
        MUTABLE((access, name, ownerAccess) -> {
            if ((ownerAccess & 0x200) != 0 && (access & 8) != 0) {
                return access;
            }
            return AccessWidener.removeFinal(access);
        }),
        ACCESSIBLE_MUTABLE((access, name, ownerAccess) -> {
            if ((ownerAccess & 0x200) != 0 && (access & 8) != 0) {
                return AccessWidener.makePublic(access);
            }
            return AccessWidener.makePublic(AccessWidener.removeFinal(access));
        });

        private final AccessOperator operator;

        private FieldAccess(AccessOperator operator) {
            this.operator = operator;
        }

        @Override
        public Access makeAccessible() {
            if (this == MUTABLE || this == ACCESSIBLE_MUTABLE) {
                return ACCESSIBLE_MUTABLE;
            }
            return ACCESSIBLE;
        }

        @Override
        public Access makeExtendable() {
            throw new UnsupportedOperationException("Fields cannot be made extendable");
        }

        @Override
        public Access makeMutable() {
            if (this == ACCESSIBLE || this == ACCESSIBLE_MUTABLE) {
                return ACCESSIBLE_MUTABLE;
            }
            return MUTABLE;
        }

        @Override
        public int apply(int access, String targetName, int ownerAccess) {
            return this.operator.apply(access, targetName, ownerAccess);
        }
    }

    @FunctionalInterface
    static interface AccessOperator {
        public int apply(int var1, String var2, int var3);
    }
}

