/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.util.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipClassLookup
implements ClassLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ZipClassLookup");
    private final ZipFile zipFile;
    private final Map<String, Optional<ClassNode>> classCache = new ConcurrentHashMap<String, Optional<ClassNode>>();

    public ZipClassLookup(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public Optional<ClassNode> getClass(String name) {
        return this.classCache.computeIfAbsent(name, this::computeClass);
    }

    protected Optional<ClassNode> computeClass(String name) {
        ZipEntry entry = this.zipFile.getEntry(name + ".class");
        if (entry != null) {
            ClassReader reader;
            try (InputStream is = this.zipFile.getInputStream(entry);){
                reader = new ClassReader(is);
            }
            catch (IOException e) {
                LOGGER.error("Error getting class entry {}", (Object)name, (Object)e);
                return Optional.empty();
            }
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            return Optional.of(node);
        }
        return Optional.empty();
    }
}

