/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.auth;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.auth.Secrets;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;

public class SecretsStore {
    private static final SecretsCache hostSecrets = new SecretsCache(GlobalVariables.serverSecretsFile);
    private static final SecretsCache clientSecrets = new SecretsCache(GlobalVariables.clientSecretsFile);

    public static Map.Entry<String, Secrets.Secret> getHostSecret(String secret) {
        hostSecrets.load();
        for (Map.Entry<String, Secrets.Secret> entry : SecretsStore.hostSecrets.cache.entrySet()) {
            String thisSecret = ((Secrets.Secret)entry.getValue()).secret();
            if (!Objects.equals(thisSecret, secret)) continue;
            return entry;
        }
        return null;
    }

    public static void saveHostSecret(String uuid, Secrets.Secret secret) {
        hostSecrets.save(uuid, secret);
    }

    public static Secrets.Secret getClientSecret(String modpack) {
        return clientSecrets.get(modpack);
    }

    public static void saveClientSecret(String modpack, Secrets.Secret secret) throws IllegalArgumentException {
        clientSecrets.save(modpack, secret);
    }

    private static class SecretsCache {
        private final ConcurrentMap<String, Secrets.Secret> cache;
        private Jsons.SecretsFields db;
        private final Path configFile;

        public SecretsCache(Path configFile) {
            this.configFile = configFile;
            this.cache = new ConcurrentHashMap<String, Secrets.Secret>();
        }

        public synchronized void load() {
            if (this.db != null) {
                return;
            }
            this.db = ConfigTools.load(this.configFile, Jsons.SecretsFields.class);
            if (this.db != null && this.db.secrets != null && !this.db.secrets.isEmpty()) {
                this.cache.putAll(this.db.secrets);
            }
        }

        public synchronized void save() {
            ConfigTools.save(this.configFile, this.db);
        }

        public Secrets.Secret get(String key) {
            this.load();
            return (Secrets.Secret)this.cache.get(key);
        }

        public void save(String key, Secrets.Secret secret) throws IllegalArgumentException {
            if (key == null || key.isBlank() || secret == null || secret.secret().isBlank()) {
                throw new IllegalArgumentException("Key or secret cannot be null or blank");
            }
            this.load();
            this.cache.put(key, secret);
            if (this.db == null) {
                this.db = new Jsons.SecretsFields();
            }
            this.db.secrets.put(key, secret);
            this.save();
        }
    }
}

