/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.crypto.generators;

import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import am_libs.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import am_libs.org.bouncycastle.crypto.CryptoServicePurpose;
import am_libs.org.bouncycastle.crypto.CryptoServicesRegistrar;
import am_libs.org.bouncycastle.crypto.KeyGenerationParameters;
import am_libs.org.bouncycastle.crypto.constraints.ConstraintUtils;
import am_libs.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import am_libs.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import am_libs.org.bouncycastle.crypto.params.DHParameters;
import am_libs.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import am_libs.org.bouncycastle.crypto.params.ElGamalParameters;
import am_libs.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import am_libs.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ElGamalKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

