/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cms.jcajce;

import am_libs.org.bouncycastle.asn1.x500.X500Name;
import am_libs.org.bouncycastle.cms.KEMRecipientId;
import am_libs.org.bouncycastle.cms.jcajce.CMSUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class JceKEMRecipientId
extends KEMRecipientId {
    public JceKEMRecipientId(X509Certificate x509Certificate) {
        super(JceKEMRecipientId.convertPrincipal(x509Certificate.getIssuerX500Principal()), x509Certificate.getSerialNumber(), CMSUtils.getSubjectKeyId(x509Certificate));
    }

    public JceKEMRecipientId(X500Principal x500Principal, BigInteger bigInteger) {
        super(JceKEMRecipientId.convertPrincipal(x500Principal), bigInteger);
    }

    public JceKEMRecipientId(X500Principal x500Principal, BigInteger bigInteger, byte[] byArray) {
        super(JceKEMRecipientId.convertPrincipal(x500Principal), bigInteger, byArray);
    }

    private static X500Name convertPrincipal(X500Principal x500Principal) {
        if (x500Principal == null) {
            return null;
        }
        return X500Name.getInstance(x500Principal.getEncoded());
    }
}

