/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.bouncycastle.cert.crmf;

import am_libs.org.bouncycastle.asn1.cmp.PBMParameter;
import am_libs.org.bouncycastle.asn1.crmf.PKMACValue;
import am_libs.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import am_libs.org.bouncycastle.cert.crmf.CRMFException;
import am_libs.org.bouncycastle.cert.crmf.PKMACBuilder;
import am_libs.org.bouncycastle.operator.MacCalculator;
import am_libs.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder pKMACBuilder) {
        this.builder = pKMACBuilder;
    }

    public boolean isValid(PKMACValue pKMACValue, char[] cArray, SubjectPublicKeyInfo subjectPublicKeyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(pKMACValue.getAlgId().getParameters()));
        MacCalculator macCalculator = this.builder.build(cArray);
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(subjectPublicKeyInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new CRMFException("exception encoding mac input: " + iOException.getMessage(), iOException);
        }
        return Arrays.constantTimeAreEqual(macCalculator.getMac(), pKMACValue.getValue().getOctets());
    }
}

