/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.client5.http.async.methods;

import am_libs.org.apache.hc.core5.http.ContentType;
import am_libs.org.apache.hc.core5.http.EntityDetails;
import am_libs.org.apache.hc.core5.http.HttpException;
import am_libs.org.apache.hc.core5.http.HttpRequest;
import am_libs.org.apache.hc.core5.http.HttpResponse;
import am_libs.org.apache.hc.core5.http.config.CharCodingConfig;
import am_libs.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import am_libs.org.apache.hc.core5.http.nio.entity.AbstractCharDataConsumer;
import am_libs.org.apache.hc.core5.http.protocol.HttpContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public abstract class AbstractCharPushConsumer
extends AbstractCharDataConsumer
implements AsyncPushConsumer {
    private final Charset defaultCharset;

    public AbstractCharPushConsumer() {
        this.defaultCharset = StandardCharsets.UTF_8;
    }

    protected AbstractCharPushConsumer(int bufSize, CharCodingConfig charCodingConfig) {
        super(bufSize, charCodingConfig);
        this.defaultCharset = charCodingConfig != null && charCodingConfig.getCharset() != null ? charCodingConfig.getCharset() : StandardCharsets.UTF_8;
    }

    protected abstract void start(HttpRequest var1, HttpResponse var2, ContentType var3) throws HttpException, IOException;

    @Override
    public final void consumePromise(HttpRequest promise, HttpResponse response, EntityDetails entityDetails, HttpContext context) throws HttpException, IOException {
        if (entityDetails != null) {
            Charset charset;
            ContentType contentType;
            try {
                contentType = ContentType.parse(entityDetails.getContentType());
            }
            catch (UnsupportedCharsetException ex) {
                throw new UnsupportedEncodingException(ex.getMessage());
            }
            Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
            if (charset == null) {
                charset = this.defaultCharset;
            }
            this.setCharset(charset);
            this.start(promise, response, contentType != null ? contentType : ContentType.DEFAULT_TEXT);
        } else {
            this.start(promise, response, null);
            this.completed();
        }
    }

    @Override
    public void failed(Exception cause) {
    }
}

