/*
 * Decompiled with CFR 0.152.
 */
package net.jewwis.betterlightning.soundevent;

import java.util.Objects;
import net.jewwis.betterlightning.Config;
import net.jewwis.betterlightning.soundevent.ModSounds;
import net.jewwis.betterlightning.ticktimer.TickEventHandler;
import net.jewwis.betterlightning.ticktimer.TickTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="betterlightning", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoundEventHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlaySound(PlaySoundEvent event) {
        if (event.getName().equalsIgnoreCase("entity.lightning_bolt.thunder")) {
            float x2 = (float)Objects.requireNonNull(event.getSound()).m_7772_();
            float y2 = (float)Objects.requireNonNull(event.getSound()).m_7780_();
            float z2 = (float)Objects.requireNonNull(event.getSound()).m_7778_();
            event.setSound(null);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                boolean isUnderground;
                float x1 = (float)player.m_20185_();
                float y1 = (float)player.m_20186_();
                float z1 = (float)player.m_20189_();
                boolean bl = isUnderground = y1 < (float)Config.muffleBelow;
                if (!isUnderground) {
                    int a = SoundEventHandler.getDistance(x1, y1, z1, x2, y2, z2);
                    if (a >= Config.distanceShort && a < Config.distanceMedium) {
                        TickEventHandler.addTimer(new TickTimer(Config.timeShort, () -> SoundEventHandler.lambda$onPlaySound$0((Player)player)));
                    } else if (a >= Config.distanceMedium && a < Config.distanceFar) {
                        TickEventHandler.addTimer(new TickTimer(Config.timeMedium, () -> SoundEventHandler.lambda$onPlaySound$1((Player)player)));
                    } else if (a >= Config.distanceFar) {
                        TickEventHandler.addTimer(new TickTimer(Config.timeLong, () -> SoundEventHandler.lambda$onPlaySound$2((Player)player)));
                    } else {
                        player.m_5496_((SoundEvent)ModSounds.NORMALTHUNDER.get(), 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private static int getDistance(float x1, float y1, float z1, float x2, float y2, float z2) {
        float xdis = (x2 - x1) * (x2 - x1);
        float ydis = (y2 - y1) * (y2 - y1);
        float zdis = (z2 - z1) * (z2 - z1);
        float a = xdis + ydis + zdis;
        if (a > 2.0f) {
            return (int)SoundEventHandler.sqrt(a);
        }
        return 2;
    }

    private static float sqrt(float a) {
        float t;
        float sqrtRoot = a / 2.0f;
        while ((t = sqrtRoot) - (sqrtRoot = (t + a / t) / 2.0f) != 0.0f) {
        }
        return sqrtRoot;
    }

    private static /* synthetic */ void lambda$onPlaySound$2(Player player) {
        player.m_5496_((SoundEvent)ModSounds.FARTHUNDER.get(), 1.0f, 1.0f);
    }

    private static /* synthetic */ void lambda$onPlaySound$1(Player player) {
        player.m_5496_((SoundEvent)ModSounds.MEDIUMTHUNDER.get(), 2.0f, 1.0f);
    }

    private static /* synthetic */ void lambda$onPlaySound$0(Player player) {
        player.m_5496_((SoundEvent)ModSounds.SHORTTHUNDER.get(), 0.8f, 1.0f);
    }
}

