/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource.resources.audio.wav;

import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WavHeader {
    private static final Logger LOGGER = LogManager.getLogger();
    private int chunkSize;
    private int dataSize;
    private int sampleRate;
    private int bitsPerSample;
    private int channels;
    private int byteRate;
    private int blockAlign;

    public static WavHeader read(InputStream inputStream) throws IOException {
        WavHeader header = new WavHeader();
        byte[] buffer = new byte[44];
        if (inputStream.read(buffer, 0, 36) != 36) {
            throw new IOException("Invalid WAV header - too short");
        }
        String riff = new String(buffer, 0, 4);
        if (!riff.equals("RIFF")) {
            throw new IOException("Invalid RIFF header: " + riff);
        }
        header.chunkSize = WavHeader.readLittleEndian(buffer, 4, 4);
        String wave = new String(buffer, 8, 4);
        if (!wave.equals("WAVE")) {
            throw new IOException("Invalid WAVE header: " + wave);
        }
        String fmt = new String(buffer, 12, 4);
        if (!fmt.equals("fmt ")) {
            throw new IOException("Invalid fmt header: " + fmt);
        }
        header.channels = WavHeader.readLittleEndian(buffer, 22, 2);
        header.sampleRate = WavHeader.readLittleEndian(buffer, 24, 4);
        header.byteRate = WavHeader.readLittleEndian(buffer, 28, 4);
        header.blockAlign = WavHeader.readLittleEndian(buffer, 32, 2);
        header.bitsPerSample = WavHeader.readLittleEndian(buffer, 34, 2);
        int fmtChunkSize = WavHeader.readLittleEndian(buffer, 16, 4);
        int extraBytes = fmtChunkSize - 16;
        if (extraBytes > 0) {
            inputStream.skip(extraBytes);
        }
        byte[] chunkHeader = new byte[8];
        boolean foundData = false;
        while (inputStream.read(chunkHeader) == 8) {
            String chunkId = new String(chunkHeader, 0, 4);
            int chunkSize = WavHeader.readLittleEndian(chunkHeader, 4, 4);
            if (chunkId.equals("data")) {
                header.dataSize = chunkSize;
                foundData = true;
                break;
            }
            long skipped = inputStream.skip(chunkSize);
            if (skipped != (long)chunkSize) {
                LOGGER.warn("[FANCYMENU] WAV Header - Failed to skip full chunk data");
                break;
            }
            if (chunkSize % 2 == 0) continue;
            inputStream.skip(1L);
        }
        if (!foundData) {
            LOGGER.warn("[FANCYMENU] WAV Header - No data chunk found");
        }
        return header;
    }

    private static int readLittleEndian(byte[] data, int offset, int bytes) {
        int value = 0;
        for (int i = 0; i < bytes; ++i) {
            value |= (data[offset + i] & 0xFF) << i * 8;
        }
        return value;
    }

    public float getDurationInSeconds() {
        if (this.sampleRate <= 0 || this.channels <= 0 || this.bitsPerSample <= 0 || this.dataSize <= 0) {
            LOGGER.warn("[FANCYMENU] WAV Header - Invalid values for duration calculation:");
            LOGGER.warn("  Sample Rate: {}", (Object)this.sampleRate);
            LOGGER.warn("  Channels: {}", (Object)this.channels);
            LOGGER.warn("  Bits Per Sample: {}", (Object)this.bitsPerSample);
            LOGGER.warn("  Data Size: {}", (Object)this.dataSize);
            return 0.0f;
        }
        int bytesPerSample = this.bitsPerSample / 8 * this.channels;
        long totalSamples = this.dataSize / bytesPerSample;
        return (float)totalSamples / (float)this.sampleRate;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public int getChannels() {
        return this.channels;
    }
}

