/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.event.acara;

import de.keksuccino.fancymenu.util.event.acara.EventBase;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class EventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final EventHandler INSTANCE = new EventHandler();
    private final Map<Class<? extends EventBase>, List<ListenerContainer>> events = new HashMap<Class<? extends EventBase>, List<ListenerContainer>>();

    public void postEvent(EventBase event) {
        if (this.eventsRegisteredForType(event.getClass())) {
            ArrayList l = new ArrayList(this.events.get(event.getClass()));
            l.sort((o1, o2) -> {
                if (o1.priority < o2.priority) {
                    return 1;
                }
                if (o1.priority > o2.priority) {
                    return -1;
                }
                return 0;
            });
            for (ListenerContainer c : l) {
                c.notifyListener(event);
            }
        }
    }

    public void registerListenersOf(Class<?> clazz) {
        this.registerListenerMethods(this.getEventMethodsOf(clazz));
    }

    public void registerListenersOf(Object object) {
        this.registerListenerMethods(this.getEventMethodsOf(object));
    }

    protected void registerListenerMethods(List<EventMethod> methods) {
        for (EventMethod m : methods) {
            Consumer<EventBase> listener = event -> {
                try {
                    m.method.invoke(m.parentObject, event);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            ListenerContainer container = new ListenerContainer(m.eventType, listener, m.priority);
            container.listenerParentClassName = m.parentClass.getName();
            container.listenerMethodName = m.method.getName();
            this.registerListener(container);
        }
    }

    protected List<EventMethod> getEventMethodsOf(Object objectOrClass) {
        ArrayList<EventMethod> l = new ArrayList<EventMethod>();
        try {
            if (objectOrClass != null) {
                boolean isClass = objectOrClass instanceof Class;
                Class<?> c = isClass ? (Class<?>)objectOrClass : objectOrClass.getClass();
                for (Method m : c.getMethods()) {
                    EventMethod em;
                    if (isClass && Modifier.isStatic(m.getModifiers()) && (em = EventMethod.tryCreateFrom(new AnalyzedMethod(m, c))) != null && this.hasEventListenerAnnotation(em)) {
                        l.add(em);
                    }
                    if (isClass || Modifier.isStatic(m.getModifiers()) || (em = EventMethod.tryCreateFrom(new AnalyzedMethod(m, objectOrClass))) == null || !this.hasEventListenerAnnotation(em)) continue;
                    l.add(em);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }

    protected boolean hasEventListenerAnnotation(@NotNull EventMethod m) {
        for (Annotation a : m.annotations) {
            if (!(a instanceof EventListener)) continue;
            return true;
        }
        return false;
    }

    public void registerListener(Consumer<EventBase> listener, Class<? extends EventBase> eventType) {
        this.registerListener(listener, eventType, 0);
    }

    public void registerListener(Consumer<EventBase> listener, Class<? extends EventBase> eventType, int priority) {
        this.registerListener(new ListenerContainer(eventType, listener, priority));
    }

    protected void registerListener(ListenerContainer listenerContainer) {
        try {
            if (!this.eventsRegisteredForType(listenerContainer.eventType)) {
                this.events.put(listenerContainer.eventType, new ArrayList());
            }
            this.events.get(listenerContainer.eventType).add(listenerContainer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean eventsRegisteredForType(Class<? extends EventBase> eventType) {
        if (eventType == null) {
            return false;
        }
        return this.events.containsKey(eventType);
    }

    protected static class ListenerContainer {
        protected final Consumer<EventBase> listener;
        protected final Class<? extends EventBase> eventType;
        protected final int priority;
        protected String listenerParentClassName = "[unknown]";
        protected String listenerMethodName = "[unknown]";

        protected ListenerContainer(Class<? extends EventBase> eventType, Consumer<EventBase> listener, int priority) {
            this.listener = listener;
            this.eventType = eventType;
            this.priority = priority;
        }

        protected void notifyListener(EventBase event) {
            try {
                this.listener.accept(event);
            }
            catch (Exception e) {
                LOGGER.error("##################################");
                LOGGER.error("[ACARA] Failed to notify event listener!");
                LOGGER.error("[ACARA] Event Type: " + this.eventType.getName());
                LOGGER.error("[ACARA] Listener Parent Class Name: " + this.listenerParentClassName);
                LOGGER.error("[ACARA] Listener Method Name In Parent Class: " + this.listenerMethodName);
                LOGGER.error("##################################");
                e.printStackTrace();
            }
        }
    }

    protected static class EventMethod
    extends AnalyzedMethod {
        protected final int priority;
        protected final Class<? extends EventBase> eventType;

        protected static EventMethod tryCreateFrom(AnalyzedMethod method) {
            EventMethod em = new EventMethod(method);
            return em.eventType != null ? em : null;
        }

        protected EventMethod(AnalyzedMethod method) {
            this.method = method.method;
            this.parentObject = method.parentObject;
            this.parentClass = method.parentClass;
            this.isStatic = method.isStatic;
            this.annotations = method.annotations;
            this.priority = this.tryGetPriority();
            this.eventType = this.tryGetEventType();
        }

        protected Class<? extends EventBase> tryGetEventType() {
            try {
                Class<?> firstParam;
                Class<?>[] params;
                if (this.method != null && (params = this.method.getParameterTypes()).length > 0 && EventBase.class.isAssignableFrom(firstParam = params[0])) {
                    return firstParam;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        protected int tryGetPriority() {
            try {
                for (Annotation a : this.annotations) {
                    if (!(a instanceof EventListener)) continue;
                    return ((EventListener)a).priority();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    protected static class AnalyzedMethod {
        protected Method method;
        protected Object parentObject;
        protected Class<?> parentClass;
        protected boolean isStatic;
        protected List<Annotation> annotations = new ArrayList<Annotation>();

        protected AnalyzedMethod() {
        }

        protected AnalyzedMethod(Method method, Object parentObjectOrClass) {
            this.method = method;
            this.parentObject = parentObjectOrClass;
            this.parentClass = this.tryGetParentClass();
            this.isStatic = Modifier.isStatic(method.getModifiers());
            AnalyzedMethod.collectMethodAnnotations(this.isStatic ? null : this.parentObject.getClass(), this.method, this.annotations);
        }

        protected Class<?> tryGetParentClass() {
            if (this.parentObject instanceof Class) {
                return (Class)this.parentObject;
            }
            return this.parentObject.getClass();
        }

        protected static void collectMethodAnnotations(Class<?> c, Method m, List<Annotation> addToList) {
            try {
                Class<?> sc;
                addToList.addAll(Arrays.asList(m.getAnnotations()));
                if (!Modifier.isStatic(m.getModifiers()) && c != null && (sc = c.getSuperclass()) != null) {
                    try {
                        Method sm = sc.getMethod(m.getName(), m.getParameterTypes());
                        AnalyzedMethod.collectMethodAnnotations(sc, sm, addToList);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

