/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static volatile boolean isConnectionAvailable = true;

    public static void init() {
        new Thread(() -> {
            try {
                isConnectionAvailable = WebUtils._isInternetAvailable();
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to update the cached internet availability value!", (Throwable)ex);
            }
            try {
                Thread.sleep(20000L);
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] Failed to sleep after updating cached internet availability value!", (Throwable)ex);
            }
        }, "FancyMenu-WebUtils-Thread").start();
    }

    public static boolean isInternetAvailable() {
        return isConnectionAvailable;
    }

    private static boolean _isInternetAvailable() {
        try {
            URL url = new URL("https://8.8.8.8");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            return responseCode >= 200 && responseCode < 300;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    public static InputStream openResourceStream(@NotNull String resourceURL) {
        try {
            URL actualURL = new URL(resourceURL);
            HttpURLConnection connection = (HttpURLConnection)actualURL.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0");
            return connection.getInputStream();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static String getMimeType(@NotNull String url) {
        try {
            URL url2 = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)url2.openConnection();
            String mimeType = connection.getContentType();
            connection.disconnect();
            return mimeType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isValidUrl(@Nullable String url) {
        if (url != null && (url.startsWith("http://") || url.startsWith("https://"))) {
            try {
                URL u = new URL(url);
                HttpURLConnection c = (HttpURLConnection)u.openConnection();
                c.addRequestProperty("User-Agent", "Mozilla/4.0");
                c.setRequestMethod("HEAD");
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception ex) {
                try {
                    URL u = new URL(url);
                    HttpURLConnection c = (HttpURLConnection)u.openConnection();
                    c.addRequestProperty("User-Agent", "Mozilla/4.0");
                    int r = c.getResponseCode();
                    if (r == 200) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static void openWebLink(@NotNull String url) {
        try {
            String s = System.getProperty("os.name").toLowerCase(Locale.ROOT);
            URL u = new URL(url);
            if (!Minecraft.f_91002_) {
                if (s.contains("win")) {
                    Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", url});
                } else {
                    if (u.getProtocol().equals("file")) {
                        url = url.replace("file:", "file://");
                    }
                    Runtime.getRuntime().exec(new String[]{"xdg-open", url});
                }
            } else {
                Runtime.getRuntime().exec(new String[]{"open", url});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

