/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.util.ConsumingSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ObjectUtils {
    public static <T> T build(@NotNull Supplier<T> builder) {
        return builder.get();
    }

    public static <T> boolean isTrueForAll(List<T> objects, ConsumingSupplier<T, Boolean> checkFor) {
        for (T object : objects) {
            if (checkFor.get(object).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isFalseForAll(List<T> objects, ConsumingSupplier<T, Boolean> checkFor) {
        for (T object : objects) {
            if (!checkFor.get(object).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isTrueOrFalseForAll(List<T> objects, ConsumingSupplier<T, Boolean> checkFor) {
        return ObjectUtils.isTrueForAll(objects, checkFor) || ObjectUtils.isFalseForAll(objects, checkFor);
    }

    @NotNull
    public static <O, F> List<F> getOfAll(Class<? extends F> getType, List<O> objects, ConsumingSupplier<O, F> getter) {
        ArrayList<F> l = new ArrayList<F>();
        for (O obj : objects) {
            l.add(getter.get(obj));
        }
        return l;
    }

    @NotNull
    public static List<Object> getOfAllUnsafe(List<Object> objects, ConsumingSupplier<Object, Object> getter) {
        return ObjectUtils.getOfAll(Object.class, objects, getter);
    }
}

