/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.elements.item.NBTBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ScreenRenderUtils;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    public ItemStack cachedStack = null;
    @NotNull
    public String itemKey = String.valueOf(BuiltInRegistries.f_257033_.m_7981_((Object)Items.f_42127_));
    public boolean enchanted = false;
    @NotNull
    public String itemCount = "1";
    @Nullable
    public String lore = null;
    @Nullable
    public String itemName = null;
    public boolean showTooltip = true;
    @Nullable
    public String nbtData = null;
    protected String lastItemKey = null;
    protected boolean lastEnchanted = false;
    protected String lastLore = null;
    protected String lastItemName = null;
    protected String lastNbtData = null;
    protected final Font font;

    public ItemElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.font = Minecraft.m_91087_().f_91062_;
    }

    protected void updateCachedItem() {
        String keyFinal = PlaceholderParser.replacePlaceholders(this.itemKey);
        String loreFinal = this.lore == null ? null : PlaceholderParser.replacePlaceholders(this.lore);
        String nameFinal = this.itemName == null ? null : PlaceholderParser.replacePlaceholders(this.itemName);
        String nbtFinal = this.nbtData == null ? null : PlaceholderParser.replacePlaceholders(this.nbtData);
        try {
            if (!(this.cachedStack != null && keyFinal.equals(this.lastItemKey) && this.enchanted == this.lastEnchanted && Objects.equals(loreFinal, this.lastLore) && Objects.equals(nameFinal, this.lastItemName) && Objects.equals(nbtFinal, this.lastNbtData))) {
                CompoundTag nbt;
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)keyFinal));
                this.cachedStack = new ItemStack((ItemLike)item);
                if (nbtFinal != null && (nbt = NBTBuilder.buildNbtFromString(this.cachedStack, nbtFinal)) != null) {
                    this.cachedStack.m_41751_(nbt);
                }
                if (this.enchanted) {
                    this.cachedStack.m_41663_(Enchantments.f_44971_, 1);
                }
                if (loreFinal != null && !loreFinal.isBlank()) {
                    ArrayList<Component> lines = new ArrayList<Component>();
                    for (String line : StringUtils.splitLines((String)loreFinal.replace("%n%", "\n"), (String)"\n")) {
                        lines.add(ItemElement.buildComponent(line));
                    }
                    ItemElement.setLore(this.cachedStack, lines);
                }
                if (nameFinal != null) {
                    this.cachedStack.m_41714_(ItemElement.buildComponent(nameFinal));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to create ItemStack instance for 'Item' element!", (Throwable)ex);
            this.cachedStack = new ItemStack((ItemLike)Items.f_42127_);
        }
        this.lastItemKey = keyFinal;
        this.lastEnchanted = this.enchanted;
        this.lastLore = loreFinal;
        this.lastItemName = nameFinal;
        this.lastNbtData = nbtFinal;
    }

    protected static void setLore(@NotNull ItemStack stack, @NotNull List<Component> loreLines) {
        CompoundTag displayTag = stack.m_41698_("display");
        ListTag loreList = new ListTag();
        for (Component line : loreLines) {
            loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)line)));
        }
        displayTag.m_128365_("Lore", (Tag)loreList);
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            this.updateCachedItem();
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            int w = this.getAbsoluteWidth();
            int h = this.getAbsoluteHeight();
            RenderSystem.enableBlend();
            if (this.cachedStack != null) {
                this.renderItem(graphics, x, y, w, h, mouseX, mouseY, this.cachedStack);
            }
            RenderSystem.disableBlend();
        }
    }

    protected void renderItem(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, @NotNull ItemStack itemStack) {
        int count = SerializationUtils.deserializeNumber(Integer.class, 1, PlaceholderParser.replacePlaceholders(this.itemCount));
        this.renderScaledItem(graphics, itemStack, x, y, width, height);
        if (count > 1) {
            this.renderItemCount(graphics, this.font, x, y, Math.max(width, height), count);
        }
        if (!ItemElement.isEditor() && this.showTooltip && UIBase.isXYInArea(mouseX, mouseY, this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight())) {
            ScreenRenderUtils.postPostRenderTask((graphics1, mouseX1, mouseY1, partial) -> this.renderItemTooltip(graphics1, mouseX, mouseY, itemStack));
        }
    }

    protected void renderScaledItem(@NotNull GuiGraphics graphics, @NotNull ItemStack stack, int x, int y, int width, int height) {
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, 0.0f);
        float scale = (float)Math.min(width, height) / 16.0f;
        pose.m_85841_(scale, scale, 1.0f);
        graphics.m_280480_(stack, 0, 0);
        pose.m_85849_();
    }

    protected void renderItemCount(@NotNull GuiGraphics graphics, @NotNull Font font, int x, int y, int size, int count) {
        PoseStack pose = graphics.m_280168_();
        String text = String.valueOf(count);
        float scaleFactor = (float)size / 16.0f;
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 200.0f);
        pose.m_85836_();
        pose.m_85841_(scaleFactor, scaleFactor, 1.0f);
        int scaledX = (int)((float)x / scaleFactor + 19.0f - 2.0f - (float)font.m_92895_(text));
        int scaledY = (int)((float)y / scaleFactor + 6.0f + 3.0f);
        graphics.m_280056_(font, text, scaledX, scaledY, -1, true);
        pose.m_85849_();
        pose.m_85849_();
    }

    protected void renderItemTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY, @NotNull ItemStack itemStack) {
        graphics.m_280677_(this.font, Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)itemStack), itemStack.m_150921_(), mouseX, mouseY);
    }
}

