/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless.forge;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import nl.teamdiopside.seamless.Reload;
import nl.teamdiopside.seamless.Seamless;

public class SeamlessForgeClient {
    public static File file = new File(Minecraft.m_91087_().f_91069_, "seamless.txt");

    public static void init() {
        Consumer<AddPackFindersEvent> packFinders = SeamlessForgeClient::addPack;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(packFinders);
        Consumer<AddReloadListenerEvent> reloadListener = addReloadListenerEvent -> addReloadListenerEvent.addListener((PreparableReloadListener)new SimpleJsonResourceReloadListener(new Gson(), "nothing"){

            protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager arg, ProfilerFiller arg2) {
                SeamlessForgeClient.reloadOutlines();
            }
        });
        Consumer<TagsUpdatedEvent> tags = tagsUpdatedEvent -> {
            if (tagsUpdatedEvent.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD) {
                SeamlessForgeClient.reloadOutlines();
            }
        };
        MinecraftForge.EVENT_BUS.addListener(reloadListener);
        MinecraftForge.EVENT_BUS.addListener(tags);
    }

    public static void reloadOutlines() {
        Reload.reload(Minecraft.m_91087_().m_91098_());
    }

    public static void addPack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            try {
                ResourceLocation folderName = new ResourceLocation("seamless", "default_seamless");
                IModFile file = ModList.get().getModFileById(folderName.m_135827_()).getFile();
                PathPackResources pack = new PathPackResources(folderName.toString(), file.findResource(new String[]{"resourcepacks/" + folderName.m_135815_()}), true);
                PackMetadataSection metadata = Objects.requireNonNull((PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_));
                event.addRepositorySource(consumer -> consumer.accept(Pack.m_245512_((String)folderName.m_135815_(), (Component)Component.m_237115_((String)"seamless.resource_pack"), (boolean)false, string -> pack, (Pack.Info)new Pack.Info(metadata.m_10373_(), metadata.m_10374_(), FeatureFlagSet.m_246902_()), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_)));
            }
            catch (Exception e) {
                Seamless.LOGGER.error("Failed to add Built-in Seamless resources");
            }
        }
    }
}

