/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import nl.teamdiopside.seamless.Seamless;

public class Reload {
    public static final List<OutlineRule> RULES = new ArrayList<OutlineRule>();

    public static void reload(ResourceManager resourceManager) {
        Reload.apply(Reload.getJsons(resourceManager));
    }

    public static void apply(Map<ResourceLocation, JsonElement> jsons) {
        Seamless.fastEnabled = (Boolean)Seamless.fastOption.m_231551_();
        RULES.clear();
        ArrayList<OutlineRule> temp = new ArrayList<OutlineRule>();
        ArrayList<JsonFile> files = new ArrayList<JsonFile>();
        jsons.forEach((key, json) -> files.add(new JsonFile((ResourceLocation)key, (JsonElement)json)));
        files.sort(Comparator.comparing(jsonFile -> jsonFile.key.toString()));
        for (JsonFile file : files) {
            ResourceLocation key2 = file.key();
            JsonElement json2 = file.json();
            if (!Seamless.modIds.contains(key2.m_135827_())) continue;
            try {
                Set<String> blocks = Reload.getSet(json2, "blocks");
                HashMap<String, Set<String>> blockstates = Reload.getBlockStates(json2, "blockstates");
                Set<String> directions = Reload.getSet(json2, "directions");
                Set<String> connectingBlocks = Reload.getSet(json2, "connecting_blocks");
                HashMap<String, Set<String>> connectingBlockstates = Reload.getBlockStates(json2, "connecting_blockstates");
                temp.add(new OutlineRule(blocks, blockstates, directions, connectingBlocks, connectingBlockstates, key2));
                Seamless.LOGGER.info("Loaded Seamless outline rule " + key2);
            }
            catch (Exception e) {
                Seamless.LOGGER.error("Failed to parse JSON for Seamless outline rule " + key2 + ".json, Error: " + e);
            }
        }
        RULES.addAll(temp);
    }

    public static Set<String> getSet(JsonElement json, String string) {
        HashSet<String> set = new HashSet<String>();
        json.getAsJsonObject().get(string).getAsJsonArray().forEach(element -> set.add(element.getAsString()));
        return set;
    }

    public static HashMap<String, Set<String>> getBlockStates(JsonElement json, String string) {
        HashMap<String, Set<String>> blockstates = new HashMap<String, Set<String>>();
        try {
            json.getAsJsonObject().get(string).getAsJsonObject().asMap().forEach((k, v) -> {
                HashSet states = new HashSet();
                v.getAsJsonArray().forEach(jsonElement -> states.add(jsonElement.getAsString()));
                blockstates.put((String)k, states);
            });
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return blockstates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<ResourceLocation, JsonElement> getJsons(ResourceManager resourceManager) {
        String directory = "seamless_rules";
        Gson gson = new Gson();
        HashMap map = Maps.newHashMap();
        int i = directory.length() + 1;
        for (Map.Entry entry : resourceManager.m_214159_(directory, resourceLocation -> resourceLocation.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation resourceLocation2 = (ResourceLocation)entry.getKey();
            String string = resourceLocation2.m_135815_();
            ResourceLocation resourceLocation22 = new ResourceLocation(resourceLocation2.m_135827_(), string.substring(i, string.length() - ".json".length()));
            try (BufferedReader reader = ((Resource)entry.getValue()).m_215508_();){
                JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonElement.class);
                if (jsonElement != null) {
                    JsonElement jsonElement2 = map.put(resourceLocation22, jsonElement);
                    if (jsonElement2 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + resourceLocation22);
                }
                Seamless.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceLocation22, (Object)resourceLocation2);
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                Seamless.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation22, resourceLocation2, exception});
            }
        }
        return map;
    }

    public record JsonFile(ResourceLocation key, JsonElement json) {
    }

    public record OutlineRule(Set<String> blocks, HashMap<String, Set<String>> blockstates, Set<String> directions, Set<String> connectingBlocks, HashMap<String, Set<String>> connectingBlockstates, ResourceLocation location) {
    }
}

