/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import nl.teamdiopside.seamless.Reload;
import nl.teamdiopside.seamless.Seamless;

public class OutlineFinder {
    public static Recursion findAndAddShapes(Level level, BlockState state, BlockPos pos, Set<BlockPos> connectedPositions, BlockPos originalPos, Entity entity) {
        connectedPositions.add(pos);
        BlockPos relativePos = pos.m_121996_((Vec3i)originalPos);
        VoxelShape shape = state.m_60651_((BlockGetter)level, pos, CollisionContext.m_82750_((Entity)entity)).m_83216_((double)relativePos.m_123341_(), (double)relativePos.m_123342_(), (double)relativePos.m_123343_());
        if (connectedPositions.size() > 1500) {
            return new Recursion(shape, connectedPositions);
        }
        for (Reload.OutlineRule outlineRule : Reload.RULES) {
            ResourceLocation location = outlineRule.location();
            if (OutlineFinder.blockDoesntMatch(outlineRule.blocks(), state.m_60734_(), null, location)) continue;
            boolean blockstatesMatch = true;
            for (Map.Entry<String, Set<String>> entry : outlineRule.blockstates().entrySet()) {
                if (!OutlineFinder.propertyDoesntMatch(state, entry.getKey(), entry.getValue(), null, location)) continue;
                blockstatesMatch = false;
            }
            if (!blockstatesMatch) continue;
            for (Direction direction : OutlineFinder.getDirections(outlineRule.directions(), location, state)) {
                BlockPos checkingPos = pos.m_121945_(direction);
                BlockState checkingState = level.m_8055_(checkingPos);
                if (connectedPositions.contains(checkingPos) || OutlineFinder.blockDoesntMatch(outlineRule.connectingBlocks(), checkingState.m_60734_(), state.m_60734_(), location)) continue;
                boolean connectingBlockstatesMatch = true;
                for (Map.Entry<String, Set<String>> entry : outlineRule.connectingBlockstates().entrySet()) {
                    if (!OutlineFinder.propertyDoesntMatch(checkingState, entry.getKey(), entry.getValue(), state, location)) continue;
                    connectingBlockstatesMatch = false;
                    break;
                }
                if (!connectingBlockstatesMatch) continue;
                Recursion recursion = OutlineFinder.findAndAddShapes(level, checkingState, checkingPos, connectedPositions, originalPos, entity);
                shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)recursion.voxelShape(), (BooleanOp)BooleanOp.f_82695_);
                connectedPositions = recursion.connectedPositions();
            }
        }
        return new Recursion(shape, connectedPositions);
    }

    public static boolean blockDoesntMatch(Set<String> set, Block checkingBlock, Block originalBlock, ResourceLocation location) {
        HashSet<Block> goodBlocks = new HashSet<Block>();
        HashSet<Block> nonoBlocks = new HashSet<Block>();
        for (String string : set) {
            if (originalBlock != null) {
                if (string.equals("/same")) {
                    goodBlocks.add(originalBlock);
                } else if (string.equals("/!same")) {
                    nonoBlocks.add(originalBlock);
                }
            }
            if (string.startsWith("!")) {
                nonoBlocks.addAll(OutlineFinder.getBlocks(string.substring(1), location));
                continue;
            }
            goodBlocks.addAll(OutlineFinder.getBlocks(string, location));
        }
        return !goodBlocks.contains(checkingBlock) || nonoBlocks.contains(checkingBlock);
    }

    public static Set<Block> getBlocks(String string, ResourceLocation location) {
        HashSet<Block> blocks = new HashSet<Block>();
        if (string.startsWith("#")) {
            TagKey blockTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(string.replace("#", "")));
            BuiltInRegistries.f_256975_.m_203561_(blockTagKey).m_203614_().forEach(blockHolder -> blocks.add((Block)blockHolder.m_203334_()));
        } else {
            if (!Seamless.modIds.contains(string.replace("#", "").split(":")[0])) {
                return blocks;
            }
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(string));
            if (block == Blocks.f_50016_ && !string.split(":")[1].equals("air")) {
                OutlineFinder.initialError("Block \"" + string + "\" from " + location + " does not exist!");
            } else {
                blocks.add(block);
            }
        }
        return blocks;
    }

    public static boolean propertyDoesntMatch(BlockState checkingState, String propertyName, Set<String> values, BlockState originalState, ResourceLocation location) {
        Property checkingProperty = checkingState.m_60734_().m_49965_().m_61081_(propertyName);
        if (checkingProperty == null) {
            OutlineFinder.initialError("Blockstate property \"" + propertyName + "\" from " + location + " does not exist for " + checkingState.m_60734_().m_49954_());
            return true;
        }
        String valueName = checkingState.m_61143_(checkingProperty).toString();
        Comparable comparable = checkingState.m_61143_(checkingProperty);
        if (comparable instanceof StringRepresentable) {
            StringRepresentable representable = (StringRepresentable)comparable;
            valueName = representable.m_7912_();
        }
        HashSet<String> goodValues = new HashSet<String>(Set.copyOf(values));
        HashSet nonoValues = new HashSet();
        boolean useNono = false;
        if (originalState != null) {
            for (String value : values) {
                Property originalProperty;
                if (!value.startsWith("/same") && !value.startsWith("/!same")) continue;
                String addToPropertyString = value.contains("+") ? value.split("\\+")[1] : "0";
                int addToProperty = 0;
                if (!addToPropertyString.equals("opposite")) {
                    try {
                        addToProperty = Integer.parseInt(addToPropertyString);
                    }
                    catch (NumberFormatException e) {
                        throw new NumberFormatException("Blockstate \"" + value + "\" from " + location + " does not exist because \"" + addToPropertyString + "\" is not an integer");
                    }
                }
                if ((originalProperty = originalState.m_60734_().m_49965_().m_61081_(propertyName)) == null) {
                    OutlineFinder.initialError("Blockstate property \"" + propertyName + "\" from " + location + " does not exist for " + originalState.m_60734_().m_49954_());
                    continue;
                }
                HashSet<String> toAdd = new HashSet<String>();
                if (originalProperty instanceof DirectionProperty) {
                    DirectionProperty directionProperty = (DirectionProperty)originalProperty;
                    Direction direction = (Direction)originalState.m_61143_((Property)directionProperty);
                    for (int i = 0; i < addToProperty; ++i) {
                        direction = direction.m_122427_();
                    }
                    if (addToPropertyString.equals("opposite")) {
                        direction = direction.m_122424_();
                    }
                    toAdd.add(direction.m_122433_());
                } else if (originalProperty == BlockStateProperties.f_61365_) {
                    toAdd.add(Direction.m_122387_((Direction.Axis)((Direction.Axis)originalState.m_61143_((Property)BlockStateProperties.f_61365_)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).toString());
                    toAdd.add(Direction.m_122387_((Direction.Axis)((Direction.Axis)originalState.m_61143_((Property)BlockStateProperties.f_61365_)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).toString());
                } else if (originalProperty == BlockStateProperties.f_61364_) {
                    toAdd.add(Direction.m_122387_((Direction.Axis)((Direction.Axis)originalState.m_61143_((Property)BlockStateProperties.f_61364_)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).toString());
                    toAdd.add(Direction.m_122387_((Direction.Axis)((Direction.Axis)originalState.m_61143_((Property)BlockStateProperties.f_61364_)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).toString());
                } else if (originalProperty instanceof IntegerProperty) {
                    IntegerProperty integerProperty = (IntegerProperty)originalProperty;
                    toAdd.add(String.valueOf((Integer)originalState.m_61143_((Property)integerProperty) + addToProperty));
                } else {
                    toAdd.add(String.valueOf(originalState.m_61143_(originalProperty)));
                }
                if (value.startsWith("/same")) {
                    goodValues.addAll(toAdd);
                    continue;
                }
                if (!value.startsWith("/!same")) continue;
                useNono = true;
                nonoValues.addAll(toAdd);
            }
        }
        boolean propertiesMatch = propertyName.equals(checkingProperty.m_61708_());
        boolean valuesMatch = goodValues.contains(valueName) || !nonoValues.contains(valueName) && useNono;
        return !propertiesMatch || !valuesMatch;
    }

    public static Set<Direction> getDirections(Set<String> set, ResourceLocation location, BlockState state) {
        HashSet<Direction> directions = new HashSet<Direction>();
        for (String string : set) {
            if (string.startsWith("/state:")) {
                Property property;
                String propertyString = string.split(":")[1].split("\\+")[0];
                String addToPropertyString = string.contains("+") ? string.split("\\+")[1] : "0";
                int addToProperty = 0;
                if (!addToPropertyString.equals("opposite")) {
                    try {
                        addToProperty = Integer.parseInt(addToPropertyString);
                    }
                    catch (NumberFormatException e) {
                        OutlineFinder.initialError("Direction \"" + string + "\" from " + location + " does not exist because \"" + addToPropertyString + "\" is not an integer");
                    }
                }
                if ((property = state.m_60734_().m_49965_().m_61081_(propertyString)) == null) {
                    OutlineFinder.initialError("Blockstate property \"" + propertyString + "\" from " + location + " does not exist for " + state.m_60734_().m_49954_());
                    continue;
                }
                if (property instanceof DirectionProperty) {
                    DirectionProperty directionProperty = (DirectionProperty)property;
                    Direction direction = (Direction)state.m_61143_((Property)directionProperty);
                    for (int i = 0; i < addToProperty; ++i) {
                        direction = direction.m_122427_();
                    }
                    if (addToPropertyString.equals("opposite")) {
                        direction = direction.m_122424_();
                    }
                    directions.add(direction);
                    continue;
                }
                if (property == BlockStateProperties.f_61365_) {
                    directions.add(Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
                    directions.add(Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
                    continue;
                }
                if (property == BlockStateProperties.f_61364_) {
                    directions.add(Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
                    directions.add(Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
                    continue;
                }
                OutlineFinder.initialError("Property \"" + propertyString + "\" from " + location + "\" is not a direction property");
                continue;
            }
            Direction direction = Direction.m_122402_((String)string);
            if (direction != null) {
                directions.add(direction);
                continue;
            }
            OutlineFinder.initialError("Direction \"" + string + "\" from " + location + " does not exist!");
        }
        return directions;
    }

    public static void initialError(String string) {
        if (!Seamless.errors.contains(string)) {
            Seamless.LOGGER.error(string);
            Seamless.errors.add(string);
        }
    }

    public record Recursion(VoxelShape voxelShape, Set<BlockPos> connectedPositions) {
    }
}

