/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.filter;

import team.creative.creativecore.common.util.filter.FilterSerializer;

@FunctionalInterface
public interface Filter<T> {
    public static final FilterSerializer SERIALIZER = new FilterSerializer();

    public boolean is(T var1);

    public static <T> Filter<T> and(Filter<T> ... filters) {
        return new FilterAnd<T>(filters);
    }

    public static <T> Filter<T> or(Filter<T> ... filters) {
        return new FilterOr<T>(filters);
    }

    public static <T> Filter<T> not(Filter<T> filter) {
        return new FilterNot<T>(filter);
    }

    public record FilterAnd<T>(Filter<T>[] filters) implements Filter<T>
    {
        @Override
        public boolean is(T t) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].is(t)) continue;
                return false;
            }
            return true;
        }
    }

    public record FilterOr<T>(Filter<T>[] filters) implements Filter<T>
    {
        @Override
        public boolean is(T t) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].is(t)) continue;
                return true;
            }
            return false;
        }
    }

    public record FilterNot<T>(Filter<T> filter) implements Filter<T>
    {
        @Override
        public boolean is(T t) {
            return !this.filter.is(t);
        }
    }
}

