/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import net.minecraft.util.Mth;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButtonHoldSlim;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiCounter
extends GuiParent {
    public int min;
    public int max;
    public final GuiParent buttons = new GuiParent(GuiFlow.STACK_Y);
    public GuiTextfield textfield;
    public final ControlFormatting buttonsFormatting;

    public GuiCounter(String name, int value) {
        this(name, value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public GuiCounter(String name, int value, int min, int max) {
        this(name, value, min, max, ControlFormatting.TRANSPARENT);
    }

    public GuiCounter(String name, int value, int min, int max, ControlFormatting buttonsFormatting) {
        super(name);
        this.min = min;
        this.max = max;
        this.flow = GuiFlow.STACK_X;
        this.setSpacing(1);
        this.textfield = new GuiTextfield("value", "" + Mth.m_14045_((int)value, (int)min, (int)max)).setDim(20, 10).setNumbersIncludingNegativeOnly();
        this.buttons.spacing = 0;
        this.buttonsFormatting = buttonsFormatting;
        this.createButtons();
        this.add(this.textfield.setExpandableX());
        this.add((GuiControl)this.buttons);
    }

    protected void createButtons() {
        this.buttons.add(new GuiButtonHoldSlim("+", x -> {
            this.textfield.setText("" + this.stepUp(this.textfield.parseInteger()));
            this.raiseEvent(new GuiControlChangedEvent<GuiCounter>(this));
        }).setTranslate("gui.plus").setDim(6, 3));
        this.buttons.add(new GuiButtonHoldSlim("-", x -> {
            this.textfield.setText("" + this.stepDown(this.textfield.parseInteger()));
            this.raiseEvent(new GuiControlChangedEvent<GuiCounter>(this));
        }).setTranslate("gui.minus").setDim(6, 4));
    }

    @Override
    public GuiCounter setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    @Override
    public GuiCounter add(GuiControl control) {
        this.addControl(control);
        return this;
    }

    public GuiButtonHoldSlim getPlusButton() {
        return (GuiButtonHoldSlim)this.buttons.get("+");
    }

    public GuiButtonHoldSlim getMinusButton() {
        return (GuiButtonHoldSlim)this.buttons.get("-");
    }

    @Override
    public boolean isExpandableX() {
        return this.expandableX;
    }

    public void resetTextfield() {
        this.textfield.setCursorPositionZero();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void raiseEvent(GuiEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            GuiControlChangedEvent controlEvent = (GuiControlChangedEvent)event;
            if (controlEvent.control.is("value")) {
                super.raiseEvent(new GuiControlChangedEvent<GuiCounter>(this));
                return;
            }
        }
        super.raiseEvent(event);
    }

    public int stepUp(int value) {
        return Math.min(this.max, value + 1);
    }

    public int stepDown(int value) {
        return Math.max(this.min, value - 1);
    }

    public int getValue() {
        return Mth.m_14045_((int)this.textfield.parseInteger(), (int)this.min, (int)this.max);
    }

    public void setValue(int value) {
        this.textfield.setText("" + Mth.m_14045_((int)value, (int)this.min, (int)this.max));
    }
}

