/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.LastAccessFile;
import io.netty.util.concurrent.DefaultThreadFactory;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FakeChunkStorage
extends ChunkStorage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Path, FakeChunkStorage> active = new HashMap<Path, FakeChunkStorage>();
    public static final Pattern REGION_FILE_PATTERN = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final Path directory;
    private final boolean writeable;
    private final AtomicBoolean sentUpgradeNotification = new AtomicBoolean();
    @Nullable
    private final LastAccessFile lastAccess;

    public static FakeChunkStorage getFor(Path directory, boolean writeable) {
        if (!Minecraft.m_91087_().m_18695_()) {
            throw new IllegalStateException("Must be called from main thread.");
        }
        return active.computeIfAbsent(directory, f -> new FakeChunkStorage(directory, writeable));
    }

    public static void closeAll() {
        for (FakeChunkStorage storage : active.values()) {
            try {
                storage.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close storage", (Throwable)e);
            }
        }
        active.clear();
    }

    private FakeChunkStorage(Path directory, boolean writeable) {
        super(directory, Minecraft.m_91087_().m_91295_(), false);
        this.directory = directory;
        this.writeable = writeable;
        LastAccessFile lastAccess = null;
        if (writeable) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
                lastAccess = new LastAccessFile(directory);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read last_access file:", (Throwable)e);
            }
        }
        this.lastAccess = lastAccess;
    }

    public void close() throws IOException {
        super.close();
        if (this.lastAccess != null) {
            int deleteUnusedRegionsAfterDays = BobbyConfig.getDeleteUnusedRegionsAfterDays();
            if (deleteUnusedRegionsAfterDays >= 0) {
                LongListIterator longListIterator = this.lastAccess.pollRegionsOlderThan(deleteUnusedRegionsAfterDays).iterator();
                while (longListIterator.hasNext()) {
                    long entry = (Long)longListIterator.next();
                    int x = ChunkPos.m_45592_((long)entry);
                    int z = ChunkPos.m_45602_((long)entry);
                    Files.deleteIfExists(this.directory.resolve("r." + x + "." + z + ".mca"));
                }
            }
            this.lastAccess.close();
        }
    }

    public void save(ChunkPos pos, CompoundTag chunk) {
        if (this.lastAccess != null) {
            this.lastAccess.touchRegion(pos.m_45610_(), pos.m_45612_());
        }
        this.m_63502_(pos, chunk);
    }

    public CompletableFuture<Optional<CompoundTag>> loadTag(ChunkPos pos) {
        return this.m_223454_(pos).thenApply(maybeNbt -> maybeNbt.map(nbt -> this.loadTag(pos, (CompoundTag)nbt)));
    }

    private CompoundTag loadTag(ChunkPos pos, CompoundTag nbt) {
        if (nbt != null && this.lastAccess != null) {
            this.lastAccess.touchRegion(pos.m_45610_(), pos.m_45612_());
        }
        if (nbt != null && nbt.m_128451_("DataVersion") != SharedConstants.m_183709_().m_183476_().m_193006_()) {
            if (this.sentUpgradeNotification.compareAndSet(false, true)) {
                Minecraft client = Minecraft.m_91087_();
                client.m_18707_(() -> {
                    MutableComponent text = Component.m_237115_((String)(this.writeable ? "bobby.upgrade.required" : "bobby.upgrade.fallback_world"));
                    client.m_18707_(() -> FakeChunkStorage.lambda$loadTag$3(client, (Component)text));
                });
            }
            return null;
        }
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(ResourceKey<Level> worldKey, BiConsumer<Integer, Integer> progress) throws IOException {
        List chunks;
        Optional<ResourceKey> generatorKey = Optional.of((ResourceKey)BuiltInRegistries.f_256914_.m_7854_((Object)FlatLevelSource.f_64164_).orElseThrow());
        try (Stream<Path> stream = Files.list(this.directory);){
            chunks = stream.map(Path::getFileName).map(Path::toString).map(REGION_FILE_PATTERN::matcher).filter(Matcher::matches).map(it -> new RegionPos(Integer.parseInt(it.group(1)), Integer.parseInt(it.group(2)))).flatMap(RegionPos::getContainedChunks).collect(Collectors.toList());
        }
        AtomicInteger done = new AtomicInteger();
        AtomicInteger total = new AtomicInteger(chunks.size());
        progress.accept(done.get(), total.get());
        IOWorker io = (IOWorker)this.m_196922_();
        int workThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        ExecutorService workExecutor = Executors.newFixedThreadPool(workThreads, (ThreadFactory)new DefaultThreadFactory("bobby-upgrade-worker", true));
        try {
            for (ChunkPos chunkPos : chunks) {
                workExecutor.submit(() -> {
                    CompoundTag nbt;
                    try {
                        nbt = ((Optional)io.m_156587_(chunkPos).join()).orElse(null);
                    }
                    catch (CompletionException e) {
                        LOGGER.warn("Error reading chunk " + chunkPos.f_45578_ + "/" + chunkPos.f_45579_ + ":", (Throwable)e);
                        nbt = null;
                    }
                    if (nbt == null) {
                        progress.accept(done.get(), total.decrementAndGet());
                        return;
                    }
                    nbt.m_128379_("isLightOn", true);
                    nbt = this.m_188288_(worldKey, null, nbt, generatorKey);
                    io.m_63538_(chunkPos, nbt).join();
                    progress.accept(done.incrementAndGet(), total.get());
                });
            }
        }
        finally {
            workExecutor.shutdown();
        }
        try {
            workExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        progress.accept(done.get(), total.get());
    }

    private static /* synthetic */ void lambda$loadTag$3(Minecraft client, Component text) {
        client.f_91065_.m_93076_().m_93785_(text);
    }

    private static final class RegionPos {
        private final int x;
        private final int z;

        private RegionPos(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public Stream<ChunkPos> getContainedChunks() {
            int baseX = this.x << 5;
            int baseZ = this.z << 5;
            ChunkPos[] result = new ChunkPos[1024];
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    result[x * 32 + z] = new ChunkPos(baseX + x, baseZ + z);
                }
            }
            return Stream.of(result);
        }

        public int x() {
            return this.x;
        }

        public int z() {
            return this.z;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RegionPos that = (RegionPos)obj;
            return this.x == that.x && this.z == that.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.z);
        }

        public String toString() {
            return "RegionPos[x=" + this.x + ", z=" + this.z + "]";
        }
    }
}

