/*
 * Decompiled with CFR 0.152.
 */
package org.groovymc.gml.internal.scripts;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import groovy.lang.GroovyClassLoader;
import groovy.util.logging.Slf4j;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModClassVisitor;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import org.codehaus.groovy.control.BytecodeProcessor;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.groovymc.gml.internal.scripts.ClassImport;
import org.groovymc.gml.internal.scripts.GImport;
import org.groovymc.gml.internal.scripts.PackageImport;
import org.groovymc.gml.internal.scripts.StaticImport;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;

public final class ScriptFileCompiler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final Supplier<List<GImport>> IMPORTS = Suppliers.memoize(() -> {
        try (InputStream is = ScriptFileCompiler.class.getResourceAsStream("/script_imports.json5");){
            if (is == null) return List.of();
            ArrayList<PackageImport> imports = new ArrayList<PackageImport>();
            JsonObject json = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(is), JsonObject.class);
            ArrayList packages = new ArrayList();
            final class 1Helper {
                1Helper() {
                }

                private static void readNested(@Nullable JsonArray array, Consumer<JsonElement> consumer) {
                    if (array == null) {
                        return;
                    }
                    array.forEach(it -> {
                        if (it.isJsonArray()) {
                            1Helper.readNested(it.getAsJsonArray(), consumer);
                        } else if (!it.isJsonNull()) {
                            consumer.accept((JsonElement)it);
                        }
                    });
                }

                @Nullable
                private static <T> T atIndexOrNull(T[] values, int index) {
                    if (index >= values.length) {
                        return null;
                    }
                    return values[index];
                }
            }
            1Helper.readNested(json.getAsJsonArray("packages"), it -> packages.add(it.getAsString()));
            imports.add(new PackageImport((String[])packages.toArray(String[]::new)));
            1Helper.readNested(json.getAsJsonArray("classes"), it -> {
                String[] split = it.getAsString().split(" as ");
                imports.add((PackageImport)((Object)new ClassImport(split[0], 1Helper.atIndexOrNull(split, 1))));
            });
            1Helper.readNested(json.getAsJsonArray("statics"), it -> {
                String[] methodSplit = it.getAsString().split("#");
                String[] aliasSplit = methodSplit[1].split(" as ");
                imports.add((PackageImport)((Object)new StaticImport(methodSplit[0], aliasSplit[0], 1Helper.atIndexOrNull(aliasSplit, 1))));
            });
            ArrayList<PackageImport> arrayList = imports;
            return arrayList;
        }
        catch (IOException e) {
            LOGGER.error("Encountered exception reading script compilation imports: ", (Throwable)e);
        }
        return List.of();
    });
    private final FileSystem fs;
    private final String modId;
    private final String rootPackage;
    private final AtomicBoolean wasCompiled;
    private final ModFile modFile;

    public ScriptFileCompiler(FileSystem fs, String modId, String rootPackage, AtomicBoolean wasCompiled, ModFile modFile) {
        this.fs = fs;
        this.modId = modId;
        this.rootPackage = rootPackage;
        this.wasCompiled = wasCompiled;
        this.modFile = modFile;
    }

    public void compile(ModFileScanData scanData) {
        if (this.wasCompiled.get()) {
            return;
        }
        this.wasCompiled.set(true);
        LOGGER.info("Compiling script mod {}", (Object)this.modId);
        try (Stream<Path> stream = Files.walk(this.fs.getPath("scripts", new String[0]), new FileVisitOption[0]).filter(it -> {
            String fileName = it.toString();
            return fileName.endsWith(".groovy") && !fileName.equals("mods.groovy");
        });){
            this.compileClasses(stream.toList());
            Path mainClassPath = this.fs.getPath(this.rootPackage, "Main.class");
            if (!Files.exists(mainClassPath, new LinkOption[0]) && !Files.exists(this.fs.getPath(this.rootPackage, "main.class"), new LinkOption[0])) {
                ClassWriter cw = new ClassWriter(2);
                this.generateMainClass().accept((ClassVisitor)cw);
                if (!Files.exists(mainClassPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(mainClassPath.getParent(), new FileAttribute[0]);
                }
                Files.write(mainClassPath, cw.toByteArray(), new OpenOption[0]);
            }
        }
        catch (IOException exception) {
            LOGGER.error("Encountered exception compiling class: ", (Throwable)exception);
        }
        this.modFile.scanFile(path -> {
            try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
                ModClassVisitor mcv = new ModClassVisitor();
                ClassReader cr = new ClassReader(inStream);
                cr.accept((ClassVisitor)mcv, 0);
                mcv.buildData(scanData.getClasses(), scanData.getAnnotations());
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    private void compileClasses(List<Path> paths) throws IOException {
        CompilationUnit unit = this.createCompilationUnit();
        paths.forEach(LamdbaExceptionUtils.rethrowConsumer(path -> unit.addSource(path.getFileName().toString().replace(".groovy", ""), Files.readString(path))));
        CompilationUnit.ClassgenCallback collector = this.createCollector(unit);
        unit.setClassgenCallback(collector);
        unit.compile(4);
        unit.getAST().getClasses().forEach(classNode -> {
            if (!classNode.hasPackageName()) {
                classNode.setName(this.rootPackage + "." + classNode.getName());
            }
        });
        unit.compile(7);
        paths.forEach(LamdbaExceptionUtils.rethrowConsumer(Files::delete));
    }

    private CompilationUnit.ClassgenCallback createCollector(CompilationUnit unit) {
        return (classVisitor, classNode) -> {
            if (classNode.getNameWithoutPackage().equalsIgnoreCase("main")) {
                groovyjarjarasm.asm.AnnotationVisitor annotation = classVisitor.visitAnnotation("Lorg/groovymc/gml/GMod;", true);
                annotation.visit("value", (Object)this.modId);
                annotation.visitEnd();
            }
            byte[] data = ((groovyjarjarasm.asm.ClassWriter)classVisitor).toByteArray();
            BytecodeProcessor bytecodePostprocessor = unit.getConfiguration().getBytecodePostprocessor();
            if (bytecodePostprocessor != null) {
                data = bytecodePostprocessor.processBytecode(classNode.getName(), data);
            }
            Path path = this.fs.getPath(classNode.getName().replace('.', '/') + ".class", new String[0]);
            try {
                if (path.getParent() != null) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                Files.write(path, data, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Exception saving script: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private CompilationUnit createCompilationUnit() {
        CompilerConfiguration compilerConfig = new CompilerConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{this.setupImports(new ImportCustomizer()), new ASTTransformationCustomizer(Map.of("category", this.modId), Slf4j.class)});
        compilerConfig.setOptimizationOptions(Map.of("parallelParse", false, "groovydoc", true, "runtimeGroovydoc", true));
        ClassLoader transformingCL = FMLLoader.getGameLayer().findLoader("forge");
        GroovyClassLoader cl = AccessController.doPrivileged(() -> new GroovyClassLoader(transformingCL));
        return new CompilationUnit(compilerConfig, null, cl);
    }

    private ImportCustomizer setupImports(ImportCustomizer customizer) {
        IMPORTS.get().forEach(it -> it.add(customizer));
        return customizer;
    }

    private ClassNode generateMainClass() {
        ClassNode node = new ClassNode();
        node.visit(61, 1, this.rootPackage + "/Main", null, Type.getInternalName(Object.class), null);
        AnnotationVisitor annotation = node.visitAnnotation("Lorg/groovymc/gml/GMod;", true);
        annotation.visit("value", (Object)this.modId);
        annotation.visitEnd();
        MethodVisitor mv = node.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label label0 = new Label();
        mv.visitLabel(label0);
        mv.visitLineNumber(5, label0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        mv.visitInsn(177);
        Label label1 = new Label();
        mv.visitLabel(label1);
        mv.visitLocalVariable("this", "L" + this.rootPackage + "/Main;", null, label0, label1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        node.visitEnd();
        return node;
    }

    public static boolean isScriptMod(IModFile file) {
        return file.getModFileInfo().getFileProperties().getOrDefault("groovyscript", false);
    }
}

